/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.api;

import java.io.InputStream;

import com.day.cq.wcm.designimporter.DesignImporterContext;

/**
 * The preprocessor that intercepts and processes every archive entry before it is extracted to the repository.
 */
public interface EntryPreprocessor {

    /**
     * Processes the input stream and returns back its processed version.
     * 
     * @param entry Name of the design package entry the content of which is getting processed.
     * @param inputStream The input stream for accessing the entry content
     * @param designImporterContext The design importer context
     * @return {@link InputStream} for reading the processed entry content.
     */
    InputStream getProcessedStream(String entry, InputStream inputStream, DesignImporterContext designImporterContext);

}
