/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Container for the HTML content of various type. Various types are classified
 * by the enumeration {@link HTMLContentType}
 */
public class HTMLContent {

    private StringBuffer markupBuffer = new StringBuffer();

    private StringBuffer cssBuffer = new StringBuffer();

    private StringBuffer scriptBuffer = new StringBuffer();

    private List<String> referencedScripts = new ArrayList<String>();

    private List<String> referencedStyleSheets = new ArrayList<String>();

    private Map<String, String> metaData = new HashMap<String, String>();

    /**
     * Gets the content by type
     *
     * @param htmlContentType One of the values from the enumeration {@link HTMLContentType}
     * @return The content as per type
     */
    public Object get(HTMLContentType htmlContentType) {
        switch (htmlContentType) {
            case META:
                return metaData;

            case MARKUP:
                return markupBuffer.toString();

            case SCRIPT_INCLUDE:
                return referencedScripts;

            case SCRIPT_INLINE:
                return scriptBuffer.toString();

            case STYLES_INLINE:
                return cssBuffer.toString();

            case STYLESHEET_INCLUDE:
                return referencedStyleSheets;
        }

        return null;
    }

    /**
     * Adds content to this object according to the {@link HTMLContentType}
     *
     * @param htmlContentType One of the values from the enumeration {@link HTMLContentType}
     * @param content The content as per type
     */
    @SuppressWarnings("unchecked")
    public void add(HTMLContentType htmlContentType, Object content) {
        switch (htmlContentType) {
            case META:
                metaData.putAll((Map<? extends String, ? extends String>) content);
                break;

            case MARKUP:
                markupBuffer.append(content);
                break;

            case SCRIPT_INCLUDE:
                referencedScripts.addAll((Collection<? extends String>) content);
                break;

            case SCRIPT_INLINE:
                scriptBuffer.append(content);
                break;

            case STYLES_INLINE:
                cssBuffer.append(content);
                break;

            case STYLESHEET_INCLUDE:
                referencedStyleSheets.addAll((Collection<? extends String>) content);
                break;
        }

    }
    


}
