/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.mobile.api.device;

import java.util.Map;

/**
 * Provides information about a specific mobile device, in the context of a specific HTTP request.
 *
 * @since CQ 5.4.0
 */
public interface Device {

    /**
     * DeviceGroup to which this Device belongs
     */
    DeviceGroup getDeviceGroup();

    /**
     * Detailed device attributes
     */
    Map<String, String> getAttributes();

    /**
     * User-Agent that was provided in the request
     */
    String getUserAgent();
}
