/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.webservicesupport;

import java.util.Comparator;
import java.util.Iterator;

import org.apache.sling.api.resource.Resource;

import aQute.bnd.annotation.ProviderType;

import com.day.cq.wcm.api.Page;

/**
 * Represents a service for managing {@link Configuration} entries.
 * 
 * @since 5.5
 */
@ProviderType
public interface ConfigurationManager {
    
    /**
     * Returns an {@link Iterator} of {@link Service} objects loaded from the
     * children of the configuration base path.
     * 
     * @return {@link Iterator} of {@link Service}'s
     */
    Iterator<Service> getServices();
    
    /**
     * Returns an {@link Iterator} of {@link Service} objects loaded from the
     * provided <code>paths</code>.
     * 
     * @param paths Service configuration paths
     * @param comparator A service comparator for ordering
     * @return {@link Iterator} of {@link Service}'s
     */
    Iterator<Service> getServices(String[] paths, Comparator<Service> comparator);
    
    /**
     * Returns the {@link Service} with the given <code>name</code>.
     * 
     * @param name servicename
     * @return {@link Service} with given name
     */
    Service getService(String name);
    
    /**
     * Returns the {@link Service} for a {@link Configuration}. If the template
     * of the configuration defines a cq:cloudservice property with the service
     * name its resolved {@link Service} is returned, <code>null</code>
     * otherwise.
     * 
     * @param configuration {@link Configuration}
     * @return {@link Service}
     */
    Service getService(Configuration configuration);
    
    /**
     * Returns the service name extracted from provided path.
     * 
     * @param path path of service persistence
     * @return {@link Service} name from given path
     */
    String getServiceName(String path);
    
    /**
     * Returns a {@link Configuration} object from the given path or
     * <code>null</code> if the resource is not adaptable.
     * 
     * @param path
     *            Path to the configuration
     * @return {@link Configuration} or <code>null</code>
     */
    Configuration getConfiguration(String path);
    
    /**
     * Returns the first {@link Configuration} object for a specific service
     * from an array of configuration paths.
     * 
     * @param servicename servicename
     * @param configPaths array of  config paths
     * @return {@link Configuration} or <code>null</code>
     */
    Configuration getConfiguration(String servicename, String[] configPaths);
    
    /**
     * Returns an {@link Iterator} of {@link Configuration} objects loaded from
     * the children of a given <code>rootPath</code>.
     * 
     * @param rootPath root path for lookup
     * @return {@link Iterator} of {@link Configuration}'s
     */
    Iterator<Configuration> getConfigurations(String rootPath);
    
    /**
     * Returns an {@link Iterator} of {@link Configuration}'s from a given
     * {@link Resource}.
     * 
     * @param resource the {@link Resource} for which the applying cloudservice {@link Configuration}s should be calculated 
     * @return {@link Iterator} of {@link Configuration}'s
     */
    Iterator<Configuration> getConfigurations(Resource resource);
    
    /**
     * Ascends the {@link Resource} until a {@link Page} with a valid
     * configuration is found. The configuration is considered valid if the node
     * has a property cq:cloudserviceconfigs.
     * 
     * @param resource {@link Resource} to check for valid configuration
     * @return {@link Page} resource or <code>null</code> if none could be
     *         found.
     */
    Resource getConfigurationResource(Resource resource);

}
