/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.exec;

import java.util.Date;

import com.day.cq.workflow.HasMetaData;
import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.model.WorkflowNode;

/**
 * A <code>WorkItem</code> is the unit that is passed through an
 * <code>{@link Workflow}</code> instance of a
 * <code>{@link WorkflowModel}</code>.
 * 
 * It contains the <code>{@link WorkflowData}</code> the instances acts on and
 * a reference to the {@link WorkflowNode} that describes the underlying
 * workflow step.
 * 
 * A <code>WorkItem</code> can be considered as a token in a petri net that
 * flows through the net during execution.
 */
public interface WorkItem extends HasMetaData {
	/**
	 * Returns the start time of the <code>WorkflowItem</code>.
	 * 
	 * @return The start time of the <code>WorkflowItem</code>.
	 */
	Date getTimeStarted();

    /**
	 * Returns the end time of the <code>WorkflowItem</code>.
	 *
	 * @return The end time of the <code>WorkflowItem</code>.
	 */
	Date getTimeEnded();

    /**
	 * Returns the <code>{@link Workflow}</code> instance assigned with this
	 * <code>WorkflowItem</code>.
	 * 
	 * @return <code>Workflow</code> of the workflow instance assigned with
	 *         the <code>WorkflowItem</code>.
	 */
	Workflow getWorkflow();

	/**
	 * Returns the current <code>{@link WorkflowNode}</code> the
	 * <code>WorkflowItem</code> is attached to.
	 * 
	 * @return The current <code>{@link WorkflowNode}</code> of the
	 *         <code>WorkflowItem</code>.
	 */
	WorkflowNode getNode();

	/**
	 * Returns the ID of the <code>WorkflowItem</code>.
	 * 
	 * @return ID of the <code>WorkflowItem</code>.
	 */
	String getId();

	/**
	 * Returns the <code>{@link WorkflowData}</code> assigned to the
	 * <code>WorkflowItem</code>.
	 * 
	 * @return the <code>{@link WorkflowData}</code> of the
	 *         <code>WorkflowItem</code>.
	 */
	WorkflowData getWorkflowData();

    /**
     * Returns the current assignee, respectively the info in which
     * inbox the workitem "resides".
     *
     * @return current assignee
     */
    String getCurrentAssignee();
}
