/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 1997 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.crx;

import javax.jcr.Session;

/**
 * This Interface defines some of the item names that are defined in the
 * jcr spec 1.0, using the default prefixes 'jcr', 'nt' and 'mix'. Please note
 * that those prefixes can by redefined by an application using the
 * {@link Session#setNamespacePrefix(String, String)} method. As a result, the
 * constants may not refer to the respective items.
 */
public interface JcrConstants {
    /**
     * jcr:autoCreated
     */
    String JCR_AUTOCREATED = "jcr:autoCreated";
    /**
     * jcr:baseVersion
     */
    String JCR_BASEVERSION = "jcr:baseVersion";
    /**
     * jcr:child
     */
    String JCR_CHILD = "jcr:child";
    /**
     * jcr:childNodeDefinition
     */
    String JCR_CHILDNODEDEFINITION = "jcr:childNodeDefinition";
    /**
     * jcr:content
     */
    String JCR_CONTENT = "jcr:content";
    /**
     * jcr:created
     */
    String JCR_CREATED = "jcr:created";
    /**
     * jcr:data
     */
    String JCR_DATA = "jcr:data";
    /**
     * jcr:defaultPrimaryType
     */
    String JCR_DEFAULTPRIMARYTYPE = "jcr:defaultPrimaryType";
    /**
     * jcr:defaultValues
     */
    String JCR_DEFAULTVALUES = "jcr:defaultValues";
    /**
     * jcr:encoding
     */
    String JCR_ENCODING = "jcr:encoding";
    /**
     * jcr:frozenMixinTypes
     */
    String JCR_FROZENMIXINTYPES = "jcr:frozenMixinTypes";
    /**
     * jcr:frozenNode
     */
    String JCR_FROZENNODE = "jcr:frozenNode";
    /**
     * jcr:frozenPrimaryType
     */
    String JCR_FROZENPRIMARYTYPE = "jcr:frozenPrimaryType";
    /**
     * jcr:frozenUuid
     */
    String JCR_FROZENUUID = "jcr:frozenUuid";
    /**
     * jcr:hasOrderableChildNodes
     */
    String JCR_HASORDERABLECHILDNODES = "jcr:hasOrderableChildNodes";
    /**
     * jcr:isCheckedOut
     */
    String JCR_ISCHECKEDOUT = "jcr:isCheckedOut";
    /**
     * jcr:isMixin
     */
    String JCR_ISMIXIN = "jcr:isMixin";
    /**
     * jcr:language
     */
    String JCR_LANGUAGE = "jcr:language";
    /**
     * jcr:lastModified
     */
    String JCR_LASTMODIFIED = "jcr:lastModified";
    /**
     * jcr:lockIsDeep
     */
    String JCR_LOCKISDEEP = "jcr:lockIsDeep";
    /**
     * jcr:lockOwner
     */
    String JCR_LOCKOWNER = "jcr:lockOwner";
    /**
     * jcr:mandatory
     */
    String JCR_MANDATORY = "jcr:mandatory";
    /**
     * jcr:mergeFailed
     */
    String JCR_MERGEFAILED = "jcr:mergeFailed";
    /**
     * jcr:mimeType
     */
    String JCR_MIMETYPE = "jcr:mimeType";
    /**
     * jcr:mixinTypes
     */
    String JCR_MIXINTYPES = "jcr:mixinTypes";
    /**
     * jcr:multiple
     */
    String JCR_MULTIPLE = "jcr:multiple";
    /**
     * jcr:name
     */
    String JCR_NAME = "jcr:name";
    /**
     * jcr:nodeTypeName
     */
    String JCR_NODETYPENAME = "jcr:nodeTypeName";
    /**
     * jcr:onParentVersion
     */
    String JCR_ONPARENTVERSION = "jcr:onParentVersion";
    /**
     * jcr:predecessors
     */
    String JCR_PREDECESSORS = "jcr:predecessors";
    /**
     * jcr:primaryItemName
     */
    String JCR_PRIMARYITEMNAME = "jcr:primaryItemName";
    /**
     * jcr:primaryType
     */
    String JCR_PRIMARYTYPE = "jcr:primaryType";
    /**
     * jcr:propertyDefinition
     */
    String JCR_PROPERTYDEFINITION = "jcr:propertyDefinition";
    /**
     * jcr:protected
     */
    String JCR_PROTECTED = "jcr:protected";
    /**
     * jcr:requiredPrimaryTypes
     */
    String JCR_REQUIREDPRIMARYTYPES = "jcr:requiredPrimaryTypes";
    /**
     * jcr:requiredType
     */
    String JCR_REQUIREDTYPE = "jcr:requiredType";
    /**
     * jcr:rootVersion
     */
    String JCR_ROOTVERSION = "jcr:rootVersion";
    /**
     * jcr:sameNameSiblings
     */
    String JCR_SAMENAMESIBLINGS = "jcr:sameNameSiblings";
    /**
     * jcr:statement
     */
    String JCR_STATEMENT = "jcr:statement";
    /**
     * jcr:successors
     */
    String JCR_SUCCESSORS = "jcr:successors";
    /**
     * jcr:supertypes
     */
    String JCR_SUPERTYPES = "jcr:supertypes";
    /**
     * jcr:system
     */
    String JCR_SYSTEM = "jcr:system";
    /**
     * jcr:uuid
     */
    String JCR_UUID = "jcr:uuid";
    /**
     * jcr:valueConstraints
     */
    String JCR_VALUECONSTRAINTS = "jcr:valueConstraints";
    /**
     * jcr:versionHistory
     */
    String JCR_VERSIONHISTORY = "jcr:versionHistory";
    /**
     * jcr:versionLabels
     */
    String JCR_VERSIONLABELS = "jcr:versionLabels";
    /**
     * jcr:versionStorage
     */
    String JCR_VERSIONSTORAGE = "jcr:versionStorage";
    /**
     * jcr:versionableUuid
     */
    String JCR_VERSIONABLEUUID = "jcr:versionableUuid";

    /**
     * Pseudo property jcr:path used with query results
     */
    String JCR_PATH = "jcr:path";
    /**
     * Pseudo property jcr:score used with query results
     */
    String JCR_SCORE = "jcr:score";

    /**
     * mix:lockable
     */
    String MIX_LOCKABLE = "mix:lockable";
    /**
     * mix:referenceable
     */
    String MIX_REFERENCEABLE = "mix:referenceable";
    /**
     * mix:versionable
     */
    String MIX_VERSIONABLE = "mix:versionable";
    /**
     * nt:base
     */
    String NT_BASE = "nt:base";
    /**
     * nt:childNodeDefinition
     */
    String NT_CHILDNODEDEFINITION = "nt:childNodeDefinition";
    /**
     * nt:file
     */
    String NT_FILE = "nt:file";
    /**
     * nt:folder
     */
    String NT_FOLDER = "nt:folder";
    /**
     * nt:frozenNode
     */
    String NT_FROZENNODE = "nt:frozenNode";
    /**
     * nt:hierarchyNode
     */
    String NT_HIERARCHYNODE = "nt:hierarchyNode";
    /**
     * nt:linkedFile
     */
    String NT_LINKEDFILE = "nt:linkedFile";
    /**
     * nt:nodeType
     */
    String NT_NODETYPE = "nt:nodeType";
    /**
     * nt:propertyDefinition
     */
    String NT_PROPERTYDEFINITION = "nt:propertyDefinition";
    /**
     * nt:query
     */
    String NT_QUERY = "nt:query";
    /**
     * nt:resource
     */
    String NT_RESOURCE = "nt:resource";
    /**
     * nt:unstructured
     */
    String NT_UNSTRUCTURED = "nt:unstructured";
    /**
     * nt:version
     */
    String NT_VERSION = "nt:version";
    /**
     * nt:versionHistory
     */
    String NT_VERSIONHISTORY = "nt:versionHistory";
    /**
     * nt:versionLabels
     */
    String NT_VERSIONLABELS = "nt:versionLabels";
    /**
     * nt:versionedChild
     */
    String NT_VERSIONEDCHILD = "nt:versionedChild";
}
