/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;

import com.day.text.GlobPattern;
import com.day.text.Text;


/**
 * The handler expander is used to expand a globbing pattern to a list of
 * handles, that match the given pattern.
 *
 * @version $Revision: 1.12 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author tripod
 * @since antbear
 */
public class URLExpander implements HandleExpander {
    /**
     * Expand the handles. assuming fully qualified URI's
     * @param pattern the pattern to match.
     */
    public String[] expand(String pattern) {
        try {
            URI uri=new URI(pattern);
            if (uri.getScheme()==null || uri.getScheme().equals("file")) {
                // expand while checking against files in directories resursively
                ArrayList list=new ArrayList();

                // Pattern may be an url - get the path component of it
                String path = uri.getPath();

                // StringBuffer should be empty not "."
                traverse_directory(list,new StringBuffer(path.length()), path.toCharArray(), 0);

                return (String[]) list.toArray(new String[list.size()]);
            } else {
                // assume url can handle this. only allow 'patterns' without wildcards
                URL url=uri.toURL();
                /** todo implement */
                throw new UnsupportedOperationException("hmpf. still have to do this");
            }
        } catch (URISyntaxException e) {
            /* ignore this */
        } catch (IOException e) {
            /* ignore this */
        }
        return new String[0];
    }
    /**
     * traverses directories an gets the filename, that match the pattern
     */
    private void traverse_directory(ArrayList list, StringBuffer dir, char[] ptr, int p) {
        // search last slash before next wildcard
        int lastslash=p;
        int first=p;
        while ((p<ptr.length) && (ptr[p]!='*') && (ptr[p]!='?') && (ptr[p]!='[') && (ptr[p]!=']')) {
            if (ptr[p]=='/') lastslash=p;
            p++;
        }
        if (p==ptr.length) {
            // no joker, just check if file exists
            dir.append('/');
            dir.append(ptr, first, p-first);
            String path=dir.toString();
            if ((new File(path)).isFile()) list.add(path);
        } else {
            // is there a slash before the wildcard
            if (lastslash>first) {
                // add part until slash to basis
                dir.append('/');
                dir.append(ptr,first,lastslash-first);
                lastslash++;
            }
            // get next slash
            while (p<ptr.length && ptr[p]!='/') p++;
            // determine globbing
            GlobPattern glob=new GlobPattern(new String(ptr, lastslash, p-lastslash));
            // now gather the files in the directory
            File directory=new File(dir.toString());
            File files[]=directory.listFiles();
            if (files==null) return;
            for (int i=0; i<files.length; i++) {
                String name=files[i].getName();
                if (glob.matches(name)) {
                    int len=dir.length();
                    dir.append('/');
                    dir.append(name);
                    if (files[i].isDirectory() && p<ptr.length) {
                        traverse_directory(list, dir, ptr, p+1);
                    } else if (files[i].isFile() && p==ptr.length) {
                        String filename=dir.toString();
                        list.add(Text.fullPath(filename,""));
                    }
                    dir.setLength(len);
                }
            }
        }
    }
}
