/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.css20;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class CSS20Attribute {
    private final List familyNames;
    private final CSSWeightValue weight;
    private final CSSStyleValue style;
    private final CSSVariantValue variant;
    private final CSSStretchValue stretch;
    private final double pointSize;
    private final double opticalSize;

    public CSS20Attribute(String[] familyNames, CSSStyleValue style, CSSVariantValue variant, CSSStretchValue stretch, CSSWeightValue weight, double pointSize, double opticalSize) {
        this.familyNames = new ArrayList(familyNames.length);
        for (int i = 0; i < familyNames.length; ++i) {
            this.familyNames.add(i, familyNames[i]);
        }
        this.weight = weight;
        this.style = style;
        this.variant = variant;
        this.stretch = stretch;
        this.pointSize = pointSize;
        this.opticalSize = opticalSize;
    }

    public CSS20Attribute(String[] familyNames, CSSStyleValue style, CSSVariantValue variant, CSSStretchValue stretch, CSSWeightValue weight, double pointSize) {
        this(familyNames, style, variant, stretch, weight, pointSize, pointSize);
    }

    public CSS20Attribute(CSS20Attribute properties) {
        this.familyNames = new ArrayList(properties.familyNames);
        this.weight = properties.weight;
        this.style = properties.style;
        this.variant = properties.variant;
        this.stretch = properties.stretch;
        this.pointSize = properties.pointSize;
        this.opticalSize = properties.opticalSize;
    }

    public List getFamilyNamesList() {
        return new ArrayList(this.familyNames);
    }

    public String[] getFamilyNames() {
        String[] array = new String[this.familyNames.size()];
        return this.familyNames.toArray(array);
    }

    public CSSStyleValue getStyle() {
        return this.style;
    }

    public int getWeight() {
        return this.weight.getValue();
    }

    public CSSVariantValue getVariant() {
        return this.variant;
    }

    public CSSStretchValue getStretch() {
        return this.stretch;
    }

    public double getPointSize() {
        return this.pointSize;
    }

    public double getOpticalSize() {
        return this.opticalSize;
    }

    public String toString() {
        return new String("[" + this.familyNames + "; " + this.pointSize + "; " + this.opticalSize + "; " + this.weight + "; " + this.style + "; " + this.stretch + "; " + this.style + "]");
    }

    public static final class CSSWeightValue
    implements Serializable {
        public static final CSSWeightValue W100 = new CSSWeightValue(100);
        public static final CSSWeightValue W200 = new CSSWeightValue(200);
        public static final CSSWeightValue W300 = new CSSWeightValue(300);
        public static final CSSWeightValue W400 = new CSSWeightValue(400);
        public static final CSSWeightValue W500 = new CSSWeightValue(500);
        public static final CSSWeightValue W600 = new CSSWeightValue(600);
        public static final CSSWeightValue W700 = new CSSWeightValue(700);
        public static final CSSWeightValue W800 = new CSSWeightValue(800);
        public static final CSSWeightValue W900 = new CSSWeightValue(900);
        public static final CSSWeightValue NORMAL = W400;
        public static final CSSWeightValue BOLD = W700;
        static final CSSWeightValue[] weightValues = new CSSWeightValue[]{W100, W200, W300, W400, W500, W600, W700, W800, W900};
        static final long serialVersionUID = 1L;
        private int value;

        private CSSWeightValue(int value) {
            this.value = value;
        }

        private Object readResolve() {
            return CSSWeightValue.getWeightValue(this.value);
        }

        protected static CSSWeightValue getWeightValue(int value) {
            for (int i = 0; i < weightValues.length; ++i) {
                if (CSSWeightValue.weightValues[i].value != value) continue;
                return weightValues[i];
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }

        public static CSSWeightValue parse(String text) {
            if (text.equalsIgnoreCase("bold")) {
                return BOLD;
            }
            if (text.equalsIgnoreCase("normal")) {
                return NORMAL;
            }
            return CSSWeightValue.getWeightValue(Integer.parseInt(text));
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public static final class CSSVariantValue
    implements Serializable {
        public static final CSSVariantValue NORMAL = new CSSVariantValue("normal", 1);
        public static final CSSVariantValue SMALL_CAPS = new CSSVariantValue("small-caps", 2);
        private static final CSSVariantValue[] variantValues = new CSSVariantValue[]{NORMAL, SMALL_CAPS};
        static final long serialVersionUID = 1L;
        private String name;
        private int value;

        private CSSVariantValue(String name, int value) {
            this.name = name;
            this.value = value;
        }

        private Object readResolve() {
            return CSSVariantValue.getVariantValue(this.value);
        }

        public static CSSVariantValue parse(String text) {
            for (int i = 0; i < variantValues.length; ++i) {
                if (!CSSVariantValue.variantValues[i].name.equalsIgnoreCase(text)) continue;
                return variantValues[i];
            }
            return null;
        }

        protected static CSSVariantValue getVariantValue(int value) {
            for (int i = 0; i < variantValues.length; ++i) {
                if (CSSVariantValue.variantValues[i].value != value) continue;
                return variantValues[i];
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class CSSStyleValue
    implements Serializable {
        public static final CSSStyleValue NORMAL = new CSSStyleValue("normal", 1);
        public static final CSSStyleValue OBLIQUE = new CSSStyleValue("oblique", 2);
        public static final CSSStyleValue ITALIC = new CSSStyleValue("italic", 3);
        private static final CSSStyleValue[] styleValues = new CSSStyleValue[]{NORMAL, OBLIQUE, ITALIC};
        static final long serialVersionUID = 1L;
        private String name;
        private int value;

        private CSSStyleValue(String name, int style) {
            this.name = name;
            this.value = style;
        }

        private Object readResolve() {
            return CSSStyleValue.getStyleValue(this.value);
        }

        public static CSSStyleValue parse(String text) {
            for (int i = 0; i < styleValues.length; ++i) {
                if (!CSSStyleValue.styleValues[i].name.equalsIgnoreCase(text)) continue;
                return styleValues[i];
            }
            return null;
        }

        protected static CSSStyleValue getStyleValue(int value) {
            for (int i = 0; i < styleValues.length; ++i) {
                if (CSSStyleValue.styleValues[i].value != value) continue;
                return styleValues[i];
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class CSSStretchValue
    implements Serializable {
        public static final CSSStretchValue ULTRACONDENSED = new CSSStretchValue("ultracondensed", 100);
        public static final CSSStretchValue EXTRACONDENSED = new CSSStretchValue("extracondensed", 200);
        public static final CSSStretchValue CONDENSED = new CSSStretchValue("condensed", 300);
        public static final CSSStretchValue SEMICONDENSED = new CSSStretchValue("semicondensed", 400);
        public static final CSSStretchValue NORMAL = new CSSStretchValue("normal", 500);
        public static final CSSStretchValue SEMIEXPANDED = new CSSStretchValue("semiexpanded", 600);
        public static final CSSStretchValue EXPANDED = new CSSStretchValue("expanded", 700);
        public static final CSSStretchValue EXTRAEXPANDED = new CSSStretchValue("extraexpanded", 800);
        public static final CSSStretchValue ULTRAEXPANDED = new CSSStretchValue("ultraexpanded", 900);
        private static final CSSStretchValue[] stretchValues = new CSSStretchValue[]{ULTRACONDENSED, EXTRACONDENSED, CONDENSED, SEMICONDENSED, NORMAL, SEMIEXPANDED, EXPANDED, EXTRAEXPANDED, ULTRAEXPANDED};
        static final long serialVersionUID = 1L;
        private String name;
        private int value;

        private CSSStretchValue(String name, int value) {
            this.name = name;
            this.value = value;
        }

        private Object readResolve() {
            return CSSStretchValue.getStretchValue(this.value);
        }

        int getValue() {
            return this.value;
        }

        public static CSSStretchValue parse(String text) {
            for (int i = 0; i < stretchValues.length; ++i) {
                if (!CSSStretchValue.stretchValues[i].name.equalsIgnoreCase(text)) continue;
                return stretchValues[i];
            }
            return null;
        }

        public static CSSStretchValue getStretchValue(int value) {
            for (int i = 0; i < stretchValues.length; ++i) {
                if (CSSStretchValue.stretchValues[i].value != value) continue;
                return stretchValues[i];
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

