/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.configuration;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.AttributeInfo;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.ChildRelnInfo;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Int;
import com.adobe.xfa.Node;
import com.adobe.xfa.Schema;
import com.adobe.xfa.SchemaPairs;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationKey;
import com.adobe.xfa.configuration.ConfigurationModel;
import com.adobe.xfa.configuration.ConfigurationUri;
import com.adobe.xfa.configuration.ConfigurationValue;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class ConfigurationSchema
extends Schema {
    private boolean mbInitPrintSchema;
    private Map<String, String> moPrintAttributes;
    private Map<String, String> moPrintComments;
    private final boolean[] mbLeafTags;
    private static final String gsXMLPrefix = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String gsNewLine = System.getProperty("line.separator");

    public ConfigurationSchema() {
        super("http://www.xfa.org/schema/xci/", 363, 718, 0, 406);
        this.mbLeafTags = new boolean[this.mnElementMax - this.mnElementMin + 1];
        this.initSchema();
    }

    @Override
    public Attribute defaultAttribute(int eAttrTag, int eClassTag) {
        AttributeInfo oAttrInfo;
        Attribute oAttr = null;
        ChildReln oReln = null;
        ChildRelnInfo oRelnInfo = super.getNodeSchema(eClassTag).getChildRelnInfo(eAttrTag);
        if (oRelnInfo != null) {
            oReln = oRelnInfo.getRelationship();
        }
        if (oReln instanceof ConfigValueChildReln) {
            oAttr = ((ConfigValueChildReln)oReln).getDefaultValue();
        }
        if (oAttr == null && (oAttrInfo = super.getNodeSchema(eClassTag).getAttributeInfo(eAttrTag)) != null) {
            oAttr = oAttrInfo.getDefault();
        }
        return oAttr;
    }

    @Override
    public Attribute newAttribute(int eAttrTag, String value, int eClassTag) {
        Attribute oAttr = null;
        ChildReln oReln = this.getNodeSchema(eClassTag).getChildRelnInfo(eAttrTag).getRelationship();
        if (oReln instanceof ConfigValueChildReln) {
            oAttr = ((ConfigValueChildReln)oReln).getDefaultValue();
        }
        if (oAttr == null) {
            oAttr = super.getNodeSchema(eClassTag).getAttributeInfo(eAttrTag).getDefault();
        }
        if (oAttr == null && (eClassTag == 58 || eClassTag == 57)) {
            return new StringAttr(XFA.getString(eAttrTag), value);
        }
        if (oAttr == null) {
            throw new ExFull(ResId.InvalidAttributeException, " (" + XFA.getString(eAttrTag) + "=" + value + ")");
        }
        return oAttr.newAttribute(value);
    }

    @Override
    protected int getElementTag(Element element) {
        if (element.isValidChild(57, 0, false, false)) {
            return 57;
        }
        if (element.isValidChild(58, 0, false, false)) {
            return 58;
        }
        return -1;
    }

    @Override
    protected void initSchema() {
        super.initSchema();
        this.addUri(334);
        this.addValue(13);
        this.addValue(23);
        this.addValue(27);
        this.addValue(29);
        this.addValue(30);
        this.addValue(369);
        this.addValue(114);
        this.addValue(336);
        this.addValue(185);
        this.addValue(116);
        this.addValue(243);
        this.addValue(246);
        this.addValue(370);
        this.addValue(65);
        this.addValue(145);
        this.addValue(7);
        this.addValue(101);
        this.addValue(309);
        this.addValue(310);
        this.addValue(302);
        this.addValue(72);
        this.addValue(250);
        this.addValue(274);
        this.addValue(67);
        this.addValue(96);
        this.addValue(375);
        this.addValue(124);
        this.addValue(129);
        this.addValue(135);
        this.addValue(139);
        this.addValue(141);
        this.addValue(142);
        this.addValue(147);
        this.addValue(152);
        this.addValue(157);
        this.addValue(158);
        this.addValue(165);
        this.addValue(380);
        this.addValue(174);
        this.addValue(386);
        this.addValue(193);
        this.addValue(196);
        this.addValue(197);
        this.addValue(387);
        this.addValue(242);
        this.addValue(391);
        this.addValue(247);
        this.addValue(256);
        this.addValue(259);
        this.addValue(262);
        this.addValue(264);
        this.addValue(279);
        this.addValue(290);
        this.addValue(303);
        this.addValue(307);
        this.addValue(399);
        this.addValue(401);
        this.addValue(402);
        this.addValue(406);
        this.addValue(345);
        this.addValue(346);
        this.addValue(393);
        this.addValue(111);
        this.addValue(304);
        this.addValue(93);
        this.addValue(308);
        this.addValue(14);
        this.addValue(198);
        this.addValue(176);
        this.addValue(112);
        this.addValue(221);
        this.addValue(291);
        this.addValue(382);
        this.addValue(177);
        this.addValue(105);
        this.addValue(268);
        this.addValue(75);
        this.addValue(379);
        this.addValue(273);
        this.addValue(128);
        this.addValue(54);
        this.addValue(53);
        this.addValue(215);
        this.addValue(404);
        this.addValue(12);
        this.addValue(202);
        this.addValue(104);
        this.addValue(224);
        this.addValue(249);
        this.addValue(117);
        this.addValue(241);
        this.addValue(11);
        this.addValue(248);
        this.addValue(226);
        this.addValue(227);
        this.addValue(136);
        this.addValue(168);
        this.addValue(289);
        this.addValue(17);
        this.addValue(199);
        this.addValue(231);
        this.addValue(18);
        this.addValue(59);
        this.addValue(156);
        this.addValue(219);
        this.addValue(15);
        this.addValue(337);
        this.addValue(338);
        this.putAttribute(118, EnumValue.getEnum(383, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(118, EnumValue.getEnum(404, EnumAttr.getEnum(0x40040001)), 10, 1, 0);
        this.putAttribute(118, 374, null, 10, 1, 0);
        this.putAttribute(118, 510, null, 10, 1, 0);
        this.putAttribute(118, 401, null, 10, 1, 0);
        this.putAttribute(118, 505, null, 10, 1, 0);
        this.setLeaf(118);
        this.putAttribute(119, EnumValue.getEnum(383, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(119, 374, null, 10, 1, 0);
        this.putAttribute(119, 510, null, 10, 1, 0);
        this.putAttribute(119, 401, null, 10, 1, 0);
        this.putAttribute(119, 691, null, 27, 1, 0);
        this.setLeaf(119);
        this.putAttribute(341, EnumValue.getEnum(383, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(341, EnumValue.getEnum(651, EnumAttr.getEnum(0x7D0000)), 10, 1, 0);
        this.putAttribute(341, EnumValue.getEnum(650, EnumAttr.getEnum(0x7E0000)), 10, 1, 0);
        this.putAttribute(341, EnumValue.getEnum(587, EnumAttr.getEnum(8323073)), 10, 1, 0);
        this.setLeaf(341);
        this.putAttribute(138, EnumValue.getEnum(383, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(138, 403, null, 10, 1, 0);
        this.putAttribute(138, EnumValue.getEnum(706, EnumAttr.getEnum(0x140000)), 10, 1, 0);
        this.putAttribute(138, EnumValue.getEnum(603, EnumAttr.getEnum(0x110001)), 10, 1, 0);
        this.putAttribute(138, 613, null, 10, 1, 0);
        this.putAttribute(138, EnumValue.getEnum(511, EnumAttr.getEnum(0x840000)), 27, 1, 0);
        this.setLeaf(138);
        this.addValue(58);
        this.putValue(57, 58, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putElement(57, 57, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.addKey(57);
        this.putValue(10, 375, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(10, 142, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(10, 141, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(10, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(10);
        this.putAttribute(181, 506, null, 24, 1, 0);
        this.addKey(181);
        this.putAttribute(266, EnumValue.getEnum(488, EnumAttr.getEnum(0x40040001)), 24, 1, 0);
        this.addKey(266);
        this.putAttribute(314, 557, new Int("maxEntries", 5), 24, 1, 0);
        this.addKey(314);
        this.putElement(35, 181, ChildReln.getZeroOrOne(), 24, 1, 0);
        this.putElement(35, 266, ChildReln.getZeroOrOne(), 24, 1, 0);
        this.putElement(35, 314, ChildReln.getZeroOrOne(), 24, 1, 0);
        this.addKey(35);
        this.putAttribute(40, 574, null, 10, 1, 0);
        this.putValue(40, 124, ChildReln.getZeroOrOne(), null, 24, 1, 0);
        this.putValue(40, 30, ChildReln.getZeroOrOne(), null, 24, 1, 0);
        this.addKey(40);
        this.addKey(385);
        this.putValue(51, 382, ChildReln.getZeroOrOne(), null, 25, 1, 0);
        this.putElement(51, 385, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.putValue(51, 177, ChildReln.getZeroOrOne(), null, 25, 1, 0);
        this.putValue(51, 307, ChildReln.getZeroOrOne(), EnumValue.getEnum(307, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putElement(51, 372, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(51, 313, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(51, 312, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(51, 179, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(51, 40, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(51, 191, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(51, 341, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(51, 338, ChildReln.getZeroOrOne(), EnumValue.getEnum(338, EnumAttr.getEnum(1082654722)), 30, 1, 0);
        this.addKey(51);
        this.putValue(55, 402, ChildReln.getZeroOrOne(), new StringAttr("type", "none"), 10, 1, 0);
        this.putValue(55, 380, ChildReln.getZeroOrOne(), new Int("compression", 6), 10, 1, 0);
        this.putValue(55, 54, ChildReln.getZeroOrOne(), EnumValue.getEnum(54, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(55, 53, ChildReln.getZeroOrOne(), EnumValue.getEnum(53, EnumAttr.getEnum(0x40040001)), 28, 1, 0);
        this.addKey(55);
        this.putValue(115, 114, ChildReln.getZeroOrOne(), EnumValue.getEnum(114, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(115, 336, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(115, 185, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(115, 116, ChildReln.getZeroOrOne(), EnumValue.getEnum(116, EnumAttr.getEnum(0x400A0000)), 10, 1, 0);
        this.putElement(115, 390, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(115);
        this.putValue(342, 12, ChildReln.getZeroOrOne(), EnumValue.getEnum(12, EnumAttr.getEnum(0x40040000)), 25, 1, 0);
        this.putValue(342, 202, ChildReln.getZeroOrOne(), null, 25, 1, 0);
        this.putValue(342, 104, ChildReln.getZeroOrOne(), EnumValue.getEnum(104, EnumAttr.getEnum(1081409536)), 25, 1, 0);
        this.putValue(342, 224, ChildReln.getZeroOrOne(), null, 25, 1, 0);
        this.putValue(342, 249, ChildReln.getZeroOrOne(), EnumValue.getEnum(249, EnumAttr.getEnum(1082785793)), 30, 1, 0);
        this.putValue(342, 117, ChildReln.getZeroOrOne(), null, 30, 1, 0);
        this.putValue(342, 241, ChildReln.getZeroOrOne(), EnumValue.getEnum(241, EnumAttr.getEnum(0x40040000)), 30, 1, 0);
        this.addKey(342);
        this.putValue(283, 11, ChildReln.getZeroOrOne(), EnumValue.getEnum(11, EnumAttr.getEnum(0x40040000)), 25, 1, 0);
        this.putValue(283, 248, ChildReln.getZeroOrOne(), null, 25, 1, 0);
        this.addKey(283);
        this.putAttribute(93, EnumValue.getEnum(713, EnumAttr.getEnum(0x690000)), 24, 1, 0);
        this.putValue(140, 111, ChildReln.getZeroOrOne(), EnumValue.getEnum(111, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(140, 304, ChildReln.getZeroOrOne(), new Int("subsetBelow", 100), 10, 1, 0);
        this.putValue(140, 93, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putValue(140, 17, ChildReln.getZeroOrMore(), null, 26, 1, 0);
        this.putValue(140, 199, ChildReln.getZeroOrMore(), null, 26, 1, 0);
        this.putElement(140, 183, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(140);
        this.putElement(188, 183, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.addKey(188);
        this.putValue(253, 138, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.addKey(253);
        this.putValue(238, 231, ChildReln.getZeroOrOne(), new Int("part", 1), 26, 1, 0);
        this.putValue(238, 18, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.putValue(238, 59, ChildReln.getZeroOrOne(), EnumValue.getEnum(59, EnumAttr.getEnum(1082261504)), 26, 1, 0);
        this.putValue(238, 156, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.addKey(238);
        this.putAttribute(223, 714, new StringAttr("x", "useXDCSetting"), 26, 1, 0);
        this.putAttribute(223, 718, new StringAttr("y", "useXDCSetting"), 26, 1, 0);
        this.addKey(223);
        this.putAttribute(52, EnumValue.getEnum(637, EnumAttr.getEnum(0x800000)), 26, 1, 0);
        this.addKey(52);
        this.putValue(352, 112, ChildReln.getZeroOrOne(), EnumValue.getEnum(112, EnumAttr.getEnum(0x40040001)), 10, 1, 0);
        this.putValue(352, 221, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(352);
        this.putValue(390, 193, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(390, 247, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(390, 246, ChildReln.getZeroOrOne(), EnumValue.getEnum(246, EnumAttr.getEnum(0x40040001)), 10, 1, 0);
        this.putValue(390, 370, ChildReln.getZeroOrOne(), EnumValue.getEnum(370, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(390, 65, ChildReln.getZeroOrOne(), EnumValue.getEnum(65, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(390, 145, ChildReln.getZeroOrOne(), EnumValue.getEnum(145, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(390, 7, ChildReln.getZeroOrOne(), EnumValue.getEnum(7, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(390, 101, ChildReln.getZeroOrOne(), EnumValue.getEnum(101, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(390, 243, ChildReln.getZeroOrOne(), EnumValue.getEnum(243, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.addKey(390);
        this.putValue(372, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(372, 259, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(372, 256, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(372, 290, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(372, 157, ChildReln.getZeroOrOne(), EnumValue.getEnum(157, EnumAttr.getEnum(0x40470000)), 25, 1, 0);
        this.putValue(372, 23, ChildReln.getZeroOrOne(), EnumValue.getEnum(23, EnumAttr.getEnum(1073938434)), 10, 1, 0);
        this.putValue(372, 346, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(372, 13, ChildReln.getZeroOrOne(), EnumValue.getEnum(13, EnumAttr.getEnum(0x40040001)), 10, 1, 0);
        this.putValue(372, 129, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putElement(372, 360, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(372, 326, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(372, 218, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(372);
        this.putValue(91, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(91);
        this.putValue(183, 118, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putValue(183, 119, ChildReln.getZeroOrMore(), null, 27, 1, 0);
        this.addKey(183);
        this.putAttribute(153, 574, null, 10, 1, 0);
        this.putValue(153, 369, ChildReln.getZeroOrOne(), new StringAttr("cSpace", "SRGB"), 10, 1, 0);
        this.putValue(153, 406, ChildReln.getZeroOrOne(), new StringAttr("version", "1.3"), 10, 1, 0);
        this.putElement(153, 55, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(153, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(153, 140, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(153);
        this.putElement(175, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(175, 354, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(175, 388, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(175);
        this.putValue(179, 399, ChildReln.getZeroOrOne(), EnumValue.getEnum(399, EnumAttr.getEnum(0x40200000)), 10, 1, 0);
        this.putValue(179, 401, ChildReln.getZeroOrOne(), EnumValue.getEnum(401, EnumAttr.getEnum(-2145517565)), 10, 1, 0);
        this.putValue(179, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(179, 386, ChildReln.getZeroOrOne(), EnumValue.getEnum(386, EnumAttr.getEnum(1075904512)), 10, 1, 0);
        this.addKey(179);
        this.putValue(384, 196, ChildReln.getZeroOrOne(), new Int("msgId", 0), 10, 1, 0);
        this.putValue(384, 279, ChildReln.getZeroOrOne(), EnumValue.getEnum(279, EnumAttr.getEnum(1076822016)), 10, 1, 0);
        this.addKey(384);
        this.putElement(191, 384, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.addKey(191);
        this.putValue(212, 96, ChildReln.getZeroOrOne(), EnumValue.getEnum(96, EnumAttr.getEnum(0x40410000)), 10, 1, 0);
        this.addKey(212);
        this.putAttribute(28, EnumValue.getEnum(377, EnumAttr.getEnum(0x670000)), 10, 1, 0);
        this.addKey(28);
        this.putValue(388, 401, ChildReln.getZeroOrOne(), EnumValue.getEnum(401, EnumAttr.getEnum(-2144927741)), 10, 1, 0);
        this.putValue(388, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(388, 402, ChildReln.getZeroOrOne(), EnumValue.getEnum(402, EnumAttr.getEnum(0x4F0000)), 10, 1, 0);
        this.addKey(388);
        this.putValue(245, 158, ChildReln.getZeroOrOne(), new Int("incrementalMerge", 1), 25, 1, 0);
        this.putValue(245, 96, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(245, 67, ChildReln.getZeroOrOne(), new Int("copies", 1), 10, 1, 0);
        this.putValue(245, 379, ChildReln.getZeroOrOne(), EnumValue.getEnum(379, EnumAttr.getEnum(1079771136)), 10, 1, 0);
        this.putValue(245, 303, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putValue(245, 404, ChildReln.getZeroOrOne(), new StringAttr("validate", "preSubmit"), 25, 1, 0);
        this.putValue(245, 226, ChildReln.getZeroOrOne(), EnumValue.getEnum(226, EnumAttr.getEnum(1081671680)), 26, 1, 0);
        this.putValue(245, 227, ChildReln.getZeroOrOne(), EnumValue.getEnum(227, EnumAttr.getEnum(1082589184)), 27, 1, 0);
        this.putValue(245, 219, ChildReln.getZeroOrOne(), EnumValue.getEnum(219, EnumAttr.getEnum(1082327040)), 26, 1, 0);
        this.putValue(245, 29, ChildReln.getZeroOrOne(), null, 30, 1, 0);
        this.putElement(245, 51, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(245, 388, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(245, 35, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(245, 394, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(245, 237, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(245, 236, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(245, 252, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(245, 153, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(245, 361, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(245, 352, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(245, 343, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(245, 103, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.addKey(245);
        this.putValue(234, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(234);
        this.putAttribute(289, 386, EnumValue.getEnum(386, EnumAttr.getEnum(8454146)), 26, 1, 0);
        this.putAttribute(236, 574, null, 10, 1, 0);
        this.putElement(236, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(236, 140, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(236, 180, ChildReln.getZeroOrOne(), 22, 1, 0);
        this.putElement(236, 223, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.putValue(236, 168, ChildReln.getZeroOrOne(), EnumValue.getEnum(168, EnumAttr.getEnum(1081737216)), 26, 1, 0);
        this.putValue(236, 289, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.putValue(236, 215, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.putElement(236, 28, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.putElement(236, 188, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.addKey(236);
        this.putAttribute(361, 574, null, 10, 1, 0);
        this.putElement(361, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(361, 140, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(361, 180, ChildReln.getZeroOrOne(), 22, 1, 0);
        this.putValue(361, 136, ChildReln.getZeroOrOne(), EnumValue.getEnum(136, EnumAttr.getEnum(0x40040000)), 26, 1, 0);
        this.putElement(361, 28, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.addKey(361);
        this.putAttribute(252, 574, null, 10, 1, 0);
        this.putElement(252, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(252, 140, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(252, 180, ChildReln.getZeroOrOne(), 22, 1, 0);
        this.putElement(252, 52, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.putValue(252, 168, ChildReln.getZeroOrOne(), EnumValue.getEnum(168, EnumAttr.getEnum(1081737216)), 26, 1, 0);
        this.putValue(252, 289, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.putValue(252, 215, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.putElement(252, 28, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.putElement(252, 188, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.addKey(252);
        this.putAttribute(343, 574, null, 10, 1, 0);
        this.putElement(343, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(343, 140, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(343);
        this.putAttribute(103, 574, null, 10, 1, 0);
        this.putElement(103, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(103, 140, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(103, 58, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putElement(103, 57, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putAttribute(103, 380, null, 22, 1, 0);
        this.addKey(103);
        this.putAttribute(103, 380, null, 22, 1, 0);
        this.addKey(180);
        this.putAttribute(237, 574, null, 10, 1, 0);
        this.putValue(237, 274, ChildReln.getZeroOrOne(), EnumValue.getEnum(274, EnumAttr.getEnum(1076690944)), 10, 1, 0);
        this.putValue(237, 302, ChildReln.getZeroOrOne(), EnumValue.getEnum(302, EnumAttr.getEnum(1077346304)), 10, 1, 0);
        this.putValue(237, 309, ChildReln.getZeroOrOne(), EnumValue.getEnum(309, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(237, 310, ChildReln.getZeroOrOne(), EnumValue.getEnum(310, EnumAttr.getEnum(1080688640)), 24, 1, 0);
        this.putValue(237, 406, ChildReln.getZeroOrOne(), new StringAttr("version", "1.7"), 10, 1, 0);
        this.putValue(237, 15, ChildReln.getZeroOrOne(), null, 28, 1, 0);
        this.putValue(237, 165, ChildReln.getZeroOrOne(), EnumValue.getEnum(165, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(237, 72, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(237, 250, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(237, 174, ChildReln.getZeroOrOne(), EnumValue.getEnum(174, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(237, 268, ChildReln.getZeroOrOne(), EnumValue.getEnum(268, EnumAttr.getEnum(1080557568)), 10, 1, 0);
        this.putElement(237, 55, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(237, 212, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(237, 115, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(237, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(237, 140, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(237, 28, ChildReln.getZeroOrOne(), 24, 1, 0);
        this.putElement(237, 342, ChildReln.getZeroOrOne(), 25, 1, 0);
        this.putElement(237, 283, ChildReln.getZeroOrOne(), 25, 1, 0);
        this.putElement(237, 238, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.addKey(237);
        this.putValue(394, 75, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(394, 128, ChildReln.getZeroOrOne(), new StringAttr("exclude", "nullTest formatTest"), 10, 1, 0);
        this.putValue(394, 273, ChildReln.getZeroOrOne(), EnumValue.getEnum(273, EnumAttr.getEnum(1080754178)), 10, 1, 0);
        this.addKey(394);
        this.putValue(263, 139, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(263, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(263);
        this.putElement(269, 275, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(269, 388, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(269, 138, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(269);
        this.putValue(275, 135, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(275, 262, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(275, 234, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(275, 388, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(275);
        this.putValue(312, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(312);
        this.putValue(313, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(313, 291, ChildReln.getZeroOrOne(), new Int("startPage", 0), 10, 1, 0);
        this.putValue(313, 27, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(313, 393, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(313, 360, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(313);
        this.putAttribute(326, 392, null, 10, 1, 0);
        this.putValue(326, 152, ChildReln.getZeroOrOne(), EnumValue.getEnum(152, EnumAttr.getEnum(1075314691)), 10, 1, 0);
        this.putValue(326, 391, ChildReln.getZeroOrOne(), EnumValue.getEnum(391, EnumAttr.getEnum(0x220002)), 10, 1, 0);
        this.putValue(326, 264, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(326, 345, ChildReln.getZeroOrOne(), EnumValue.getEnum(345, EnumAttr.getEnum(1077870596)), 10, 1, 0);
        this.putValue(326, 242, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(326, 197, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(326, 147, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(326);
        this.putValue(333, 375, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(333, 142, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(333, 350, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(333, 349, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(333, 275, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(333);
        this.putValue(349, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(349);
        this.putValue(350, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(350, 360, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(350);
        this.putValue(351, 387, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(351, 51, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(351, 275, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(351, 333, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(351, 10, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(351, 263, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(351, 175, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(351, 269, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(351);
        this.putAttribute(16, 574, null, 10, 1, 0);
        this.putElement(16, 51, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(16, 58, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putElement(16, 57, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.addKey(16);
        this.putElement(8, 9, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(8, 303, ChildReln.getZeroOrMore(), null, 28, 1, 0);
        this.putElement(8, 51, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(8, 58, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putElement(8, 57, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putValue(8, 404, ChildReln.getZeroOrOne(), new StringAttr("validate", "preSubmit"), 28, 1, 0);
        this.putValue(8, 337, ChildReln.getZeroOrOne(), new StringAttr("validateApprovalSignatures", "docReady postSign"), 28, 1, 0);
        this.addKey(8);
        this.putValue(9, 105, ChildReln.getZeroOrOne(), EnumValue.getEnum(105, EnumAttr.getEnum(0x40660000)), 10, 1, 0);
        this.addKey(9);
        this.putValue(354, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(354);
        this.putValue(360, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(360, 91, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(360);
        this.putValue(218, 334, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(218);
        this.putAttribute(21, EnumValue.getEnum(383, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(21, 574, null, 10, 1, 0);
        this.putAttribute(21, 380, new Int("level", 0), 10, 1, 0);
        this.setLeaf(21);
        this.putValue(322, 21, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.addKey(322);
        this.putAttribute(56, EnumValue.getEnum(383, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(56, 374, null, 10, 1, 0);
        this.putElement(56, 245, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(56, 322, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(56, 16, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(56, 57, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(56, 253, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(56, 8, ChildReln.getZeroOrOne(), 10, 1, 0);
    }

    @Override
    protected Element newElement(int eTag, Element parent, Node prevSibling) {
        Element newNode;
        switch (eTag) {
            case 56: {
                newNode = new ConfigurationModel(parent, prevSibling);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: 
            case 35: 
            case 40: 
            case 51: 
            case 52: 
            case 55: 
            case 57: 
            case 91: 
            case 103: 
            case 115: 
            case 140: 
            case 153: 
            case 175: 
            case 179: 
            case 180: 
            case 181: 
            case 183: 
            case 188: 
            case 191: 
            case 212: 
            case 218: 
            case 223: 
            case 234: 
            case 236: 
            case 237: 
            case 238: 
            case 245: 
            case 252: 
            case 253: 
            case 263: 
            case 266: 
            case 269: 
            case 275: 
            case 283: 
            case 312: 
            case 313: 
            case 314: 
            case 322: 
            case 326: 
            case 333: 
            case 342: 
            case 343: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 354: 
            case 360: 
            case 361: 
            case 372: 
            case 384: 
            case 385: 
            case 388: 
            case 390: 
            case 394: {
                newNode = new ConfigurationKey(parent, prevSibling);
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 65: 
            case 67: 
            case 72: 
            case 75: 
            case 93: 
            case 96: 
            case 101: 
            case 104: 
            case 105: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: 
            case 128: 
            case 129: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 141: 
            case 142: 
            case 145: 
            case 147: 
            case 152: 
            case 156: 
            case 157: 
            case 158: 
            case 165: 
            case 168: 
            case 174: 
            case 176: 
            case 177: 
            case 185: 
            case 193: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 202: 
            case 215: 
            case 219: 
            case 221: 
            case 224: 
            case 226: 
            case 227: 
            case 231: 
            case 241: 
            case 242: 
            case 243: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 256: 
            case 259: 
            case 262: 
            case 264: 
            case 268: 
            case 273: 
            case 274: 
            case 279: 
            case 289: 
            case 290: 
            case 291: 
            case 302: 
            case 303: 
            case 304: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 336: 
            case 337: 
            case 338: 
            case 341: 
            case 345: 
            case 346: 
            case 369: 
            case 370: 
            case 375: 
            case 379: 
            case 380: 
            case 382: 
            case 386: 
            case 387: 
            case 391: 
            case 393: 
            case 399: 
            case 401: 
            case 402: 
            case 404: 
            case 406: {
                newNode = new ConfigurationValue(parent, prevSibling);
                break;
            }
            case 334: {
                newNode = new ConfigurationUri(parent, prevSibling);
                break;
            }
            default: {
                return null;
            }
        }
        newNode.setClass(XFA.getAtom(eTag), eTag);
        return newNode;
    }

    private void addKey(int eTag) {
        this.putAttribute(eTag, EnumValue.getEnum(383, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(eTag, 374, null, 10, 1, 0);
    }

    private void addValue(int eTag) {
        this.putAttribute(eTag, EnumValue.getEnum(383, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(eTag, 374, null, 10, 1, 0);
        this.putElement(eTag, 0, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.setLeaf(eTag);
    }

    private void addUri(int eTag) {
        this.putAttribute(eTag, EnumValue.getEnum(383, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(eTag, 374, null, 10, 1, 0);
        this.putElement(eTag, 0, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.setLeaf(eTag);
    }

    private void putValue(int eParent, int eTag, ChildReln oRelation, Attribute oDefaultValue, int nVersionIntro, int nAvailability, int nVersionDep) {
        ConfigValueChildReln oNewRelation = null;
        oNewRelation = oDefaultValue == null ? new ConfigValueChildReln(oRelation, new StringAttr(XFA.getString(eTag), "")) : new ConfigValueChildReln(oRelation, oDefaultValue);
        this.putElement(eParent, eTag, oNewRelation, nVersionIntro, nAvailability, nVersionDep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printConfigSchema(String sSchemaName, String sUri, boolean bWriteToStdout) {
        String sConfiguration;
        block22: {
            StringBuilder sConfigurationSchema = new StringBuilder();
            boolean bPrint = true;
            int nPos = XFA.getTag(sSchemaName.intern());
            if (nPos >= 0) {
                if (nPos == 58) {
                    bPrint = false;
                } else if (nPos == 57) {
                    bPrint = false;
                }
            } else {
                nPos = 16;
            }
            if (bPrint) {
                if (!this.mbInitPrintSchema) {
                    this.initPrintSchema();
                }
                sConfigurationSchema.ensureCapacity(5120);
                sConfigurationSchema.append(gsXMLPrefix);
                sConfigurationSchema.append(gsNewLine);
                sConfigurationSchema.append('<');
                sConfigurationSchema.append("xdp:xdp");
                sConfigurationSchema.append(' ');
                sConfigurationSchema.append("xmlns");
                sConfigurationSchema.append(':');
                sConfigurationSchema.append("xdp");
                sConfigurationSchema.append('=');
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append("http://ns.adobe.com/xdp/");
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append('>');
                sConfigurationSchema.append(gsNewLine);
                sConfigurationSchema.append("   ");
                sConfigurationSchema.append('<');
                sConfigurationSchema.append("config");
                sConfigurationSchema.append(' ');
                sConfigurationSchema.append("xmlns");
                sConfigurationSchema.append('=');
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append(ConfigurationModel.configurationNS());
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append(' ');
                sConfigurationSchema.append("xmlns");
                sConfigurationSchema.append(':');
                sConfigurationSchema.append("xfa");
                sConfigurationSchema.append('=');
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append(ConfigurationModel.configurationNS());
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append('>');
                sConfigurationSchema.append(gsNewLine);
                if (nPos <= 361) {
                    String sName = null;
                    if (nPos == 16) {
                        sName = sSchemaName;
                    }
                    this.printSchema(sConfigurationSchema, 56, nPos, 2, sName, "   ");
                }
                sConfigurationSchema.append("   ");
                sConfigurationSchema.append('<');
                sConfigurationSchema.append('/');
                sConfigurationSchema.append("config");
                sConfigurationSchema.append('>');
                sConfigurationSchema.append(gsNewLine);
                sConfigurationSchema.append('<');
                sConfigurationSchema.append('/');
                sConfigurationSchema.append("xdp:xdp");
                sConfigurationSchema.append('>');
                sConfigurationSchema.append(gsNewLine);
            }
            sConfiguration = sConfigurationSchema.toString();
            if (!StringUtils.isEmpty(sUri)) {
                try {
                    String outputStreamFile = sUri;
                    if (outputStreamFile.indexOf(".xci") == -1) {
                        outputStreamFile = sUri + "." + "xci";
                    }
                    Writer oStream = null;
                    try {
                        oStream = new OutputStreamWriter((OutputStream)new FileOutputStream(outputStreamFile), "UTF-8");
                        oStream.write(sConfiguration);
                        oStream.write(gsNewLine);
                        break block22;
                    }
                    finally {
                        if (oStream != null) {
                            try {
                                oStream.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
                catch (Exception e) {
                    throw new ExFull(e);
                }
            }
            if (bWriteToStdout) {
                System.out.println(sConfiguration);
            }
        }
        return sConfiguration;
    }

    private void initPrintSchema() {
        this.moPrintAttributes = new HashMap<String, String>(4);
        this.moPrintComments = new HashMap<String, String>(16);
        MsgFormat oPrintAttrPa = new MsgFormat(ResId.XFAConfigPrintAttrPa);
        this.moPrintAttributes.put("pa", oPrintAttrPa.toString());
        MsgFormat oPrintAttrTp = new MsgFormat(ResId.XFAConfigPrintAttrTp);
        this.moPrintAttributes.put("tp", oPrintAttrTp.toString());
        MsgFormat oPrintCmntCommonUri = new MsgFormat(ResId.XFAConfigPrintCmmntCommonUri);
        this.moPrintComments.put("common.uri", oPrintCmntCommonUri.toString());
        MsgFormat oPrintCmntPaDestination = new MsgFormat(ResId.XFAConfigPrintCmmntPaDestination);
        this.moPrintComments.put("present.destination", oPrintCmntPaDestination.toString());
        MsgFormat oConfigPrintCmmntcSpace = new MsgFormat(ResId.XFAConfigPrintCmmntcSpace);
        this.moPrintComments.put("image.cSpace", oConfigPrintCmmntcSpace.toString());
        MsgFormat oPrintCmntCompressionTypeImage = new MsgFormat(ResId.XFAConfigPrintCmmntCompressionTypeTiff);
        this.moPrintComments.put("image.compression.type", oPrintCmntCompressionTypeImage.toString());
        MsgFormat oPrintCmntCompressionLevel = new MsgFormat(ResId.XFAConfigPrintCmmntCompressionLevel);
        this.moPrintComments.put("pdf.compression.level", oPrintCmntCompressionLevel.toString());
        MsgFormat oPrintCmntPdfVersion = new MsgFormat(ResId.XFAConfigPrintCmmntPdfVersion);
        this.moPrintComments.put("pdf.version", oPrintCmntPdfVersion.toString());
        MsgFormat oPrintCmntSubsetBelow = new MsgFormat(ResId.XFAConfigPrintCmmntSubsetBelow);
        this.moPrintComments.put("pdf.fontInfo.subsetBelow", oPrintCmntSubsetBelow.toString());
        this.moPrintComments.put("pcl.fontInfo.subsetBelow", oPrintCmntSubsetBelow.toString());
        this.moPrintComments.put("image.fontInfo.subsetBelow", oPrintCmntSubsetBelow.toString());
        this.moPrintComments.put("ps.fontInfo.subsetBelow", oPrintCmntSubsetBelow.toString());
        this.moPrintComments.put("zpl.fontInfo.subsetBelow", oPrintCmntSubsetBelow.toString());
        MsgFormat oPrintCmntFontMapEquate = new MsgFormat(ResId.XFAConfigPrintCmmntFontMapEquate);
        this.moPrintComments.put("fontInfo.map.equate", oPrintCmntFontMapEquate.toString());
        MsgFormat oPrintCmntTraceArea = new MsgFormat(ResId.XFAConfigPrintCmmntTraceArea);
        this.moPrintComments.put("trace.area", oPrintCmntTraceArea.toString());
        this.mbInitPrintSchema = true;
    }

    private String getComment(String sSomeExpr) {
        String sAttr = this.moPrintComments.get(sSomeExpr);
        int nFoundAt = 0;
        while (StringUtils.isEmpty(sAttr) && (nFoundAt = sSomeExpr.indexOf(46, nFoundAt)) != -1) {
            String sNewString = sSomeExpr.substring(++nFoundAt);
            sAttr = this.moPrintComments.get(sNewString);
        }
        return sAttr;
    }

    private void printSchema(StringBuilder sBuffer, int eParentTag, int eTag, int nOccurs, String sContext, String sIndent) {
        SchemaPairs oAttrs;
        String sNextIndent = sIndent + "   ";
        String sTag = XFA.getString(eTag);
        sBuffer.append(sNextIndent);
        sBuffer.append('<');
        sBuffer.append(sTag);
        if (eTag == 16) {
            sBuffer.append(' ');
            sBuffer.append("name");
            sBuffer.append('=');
            sBuffer.append('\"');
            sBuffer.append(sContext);
            sBuffer.append('\"');
        }
        if ((oAttrs = super.getNodeSchema(eTag).getValidAttributes()) != null) {
            for (int i = 0; i < oAttrs.size(); ++i) {
                int eAttrTag = oAttrs.key(i);
                if (eAttrTag == 383 || eAttrTag == 374 || eTag == 16 && eAttrTag == 574) continue;
                Attribute oAttr = (Attribute)oAttrs.value(i);
                sBuffer.append(' ');
                sBuffer.append(XFA.getString(eAttrTag));
                sBuffer.append('=');
                sBuffer.append('\"');
                sBuffer.append(oAttr.toString());
                sBuffer.append('\"');
            }
        }
        StringBuilder sNewContext = new StringBuilder();
        if (sContext != null) {
            sNewContext.append(sContext);
        }
        if (sNewContext.length() != 0) {
            sNewContext.append('.');
        }
        sNewContext.append(sTag);
        String sAttr = this.moPrintAttributes.get(sNewContext.toString());
        if (!StringUtils.isEmpty(sAttr)) {
            sBuffer.append(' ');
            sBuffer.append(sAttr);
        }
        StringBuilder sCommentText = new StringBuilder();
        String sComments = this.getComment(sNewContext.toString());
        if (sComments != null) {
            sCommentText.append(sComments);
        }
        if (nOccurs != 1) {
            sCommentText.append(' ');
            if (nOccurs == 2) {
                sCommentText.append("[0..n]");
            } else if (nOccurs == 3) {
                sCommentText.append("[1..n]");
            } else if (nOccurs == 4) {
                sCommentText.append("oneOfChild");
            }
            sCommentText.append(' ');
        }
        if (this.isLeaf(eTag)) {
            EnumAttr oEnum;
            String[] oValues;
            Attribute oDefaultValue = this.defaultAttribute(eTag, eParentTag);
            String sDefaultValue = "";
            if (oDefaultValue != null) {
                sDefaultValue = oDefaultValue.toString();
            }
            if (StringUtils.isEmpty(sDefaultValue)) {
                sBuffer.append("/>");
            } else {
                sBuffer.append(">");
                sBuffer.append(sDefaultValue);
                sBuffer.append("</");
                sBuffer.append(sTag);
                sBuffer.append(">");
            }
            if (oDefaultValue instanceof EnumValue && (oValues = (oEnum = ((EnumValue)oDefaultValue).getAttr()).getStrings()).length > 0) {
                sBuffer.append(' ');
                sBuffer.append("<!--");
                sBuffer.append(' ');
                for (int i = 0; i < oValues.length; ++i) {
                    if (i != 0) {
                        sBuffer.append('|');
                    }
                    sBuffer.append(oValues[i]);
                }
                sBuffer.append(' ');
                sBuffer.append("-->");
            }
            if (sCommentText.length() != 0) {
                sBuffer.append(' ');
                sBuffer.append("<!--");
                sBuffer.append(' ');
                sBuffer.append(sCommentText.toString());
                sBuffer.append(' ');
                sBuffer.append("-->");
            }
            sBuffer.append(gsNewLine);
            return;
        }
        sBuffer.append('>');
        if (sCommentText.length() != 0) {
            sBuffer.append(' ');
            sBuffer.append("<!--");
            sBuffer.append(' ');
            sBuffer.append((CharSequence)sCommentText);
            sBuffer.append(' ');
            sBuffer.append("-->");
        }
        sBuffer.append(gsNewLine);
        SchemaPairs oChildren = super.getNodeSchema(eTag).getValidChildren();
        if (oChildren != null) {
            for (int i = 0; i < oChildren.size(); ++i) {
                int eChild = oChildren.key(i);
                if (eChild == 0 || eChild == 58 || eChild == 57) continue;
                ChildReln oReln = (ChildReln)oChildren.value(i);
                this.printSchema(sBuffer, eTag, eChild, oReln.getOccurrence(), sNewContext.toString(), sNextIndent);
            }
        }
        sBuffer.append(sNextIndent);
        sBuffer.append("</");
        sBuffer.append(sTag);
        sBuffer.append('>');
        sBuffer.append(gsNewLine);
    }

    private void setLeaf(int eTag) {
        this.mbLeafTags[eTag - this.mnElementMin] = true;
    }

    private boolean isLeaf(int eTag) {
        return this.mbLeafTags[eTag - this.mnElementMin];
    }

    private static class ConfigValueChildReln
    extends ChildReln {
        private final Attribute moDefaultValue;

        ConfigValueChildReln(ChildReln oOther, Attribute oDefaultValue) {
            super(oOther.getOccurrence(), oOther.getMax());
            this.moDefaultValue = oDefaultValue;
        }

        Attribute getDefaultValue() {
            return this.moDefaultValue;
        }

        @Override
        public boolean isBaseClass() {
            return false;
        }
    }
}

