/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.aggregate;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.plugins.index.aggregate.AggregateIndexPlan;
import org.apache.jackrabbit.oak.plugins.index.aggregate.AggregationCursor;
import org.apache.jackrabbit.oak.plugins.index.cursor.Cursors;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextContains;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateIndex
implements QueryIndex.AdvanceFulltextQueryIndex {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateIndex.class);
    private final QueryIndex.AdvanceFulltextQueryIndex baseIndex;

    public AggregateIndex(QueryIndex.AdvanceFulltextQueryIndex baseIndex) {
        this.baseIndex = baseIndex;
    }

    @Override
    public double getMinimumCost() {
        return this.baseIndex.getMinimumCost();
    }

    @Override
    public double getCost(Filter filter, NodeState rootState) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    @Override
    public Cursor query(Filter filter, NodeState rootState) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    @Override
    public List<QueryIndex.IndexPlan> getPlans(Filter filter, List<QueryIndex.OrderEntry> sortOrder, NodeState rootState) {
        if (this.baseIndex == null) {
            return Collections.emptyList();
        }
        FullTextExpression e = filter.getFullTextConstraint();
        if (this.getNodeAggregator() == null || e == null) {
            return this.baseIndex.getPlans(filter, sortOrder, rootState);
        }
        if (!AggregateIndex.hasCompositeExpression(e)) {
            return this.baseIndex.getPlans(AggregateIndex.newAggregationFilter(filter, null), sortOrder, rootState);
        }
        AggregateIndexPlan plan = new AggregateIndexPlan(filter);
        this.collectCombinedPlan(e, filter, sortOrder, rootState, plan, "");
        if (plan.containsPathWithoutPlan()) {
            LOG.debug("Full-text index without plan: " + e);
            return Collections.emptyList();
        }
        return Collections.singletonList(plan);
    }

    @Override
    public Cursor query(QueryIndex.IndexPlan plan, NodeState rootState) {
        if (this.getNodeAggregator() == null) {
            return this.baseIndex.query(plan, rootState);
        }
        if (!(plan instanceof AggregateIndexPlan)) {
            plan.setFilter(AggregateIndex.newAggregationFilter(plan.getFilter(), null));
            return this.newAggregationCursor(plan, rootState);
        }
        Filter filter = plan.getFilter();
        AggregateIndexPlan aggPlan = (AggregateIndexPlan)plan;
        FullTextExpression constraint = filter.getFullTextConstraint();
        return this.flatten(constraint, aggPlan, filter, rootState, "");
    }

    private static boolean hasCompositeExpression(FullTextExpression ft) {
        if (ft == null) {
            return false;
        }
        final AtomicReference<Boolean> composite = new AtomicReference<Boolean>();
        composite.set(false);
        ft.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextContains contains) {
                return contains.getBase().accept(this);
            }

            @Override
            public boolean visit(FullTextTerm term) {
                return true;
            }

            @Override
            public boolean visit(FullTextAnd and) {
                composite.set(true);
                return true;
            }

            @Override
            public boolean visit(FullTextOr or) {
                composite.set(true);
                return true;
            }
        });
        return (Boolean)composite.get() != false && !AggregateIndex.hasNegativeContains(ft);
    }

    private static boolean hasNegativeContains(FullTextExpression ft) {
        if (ft == null) {
            return false;
        }
        final AtomicReference<Boolean> hasNegative = new AtomicReference<Boolean>();
        hasNegative.set(false);
        ft.accept(new FullTextVisitor.FullTextVisitorBase(){

            @Override
            public boolean visit(FullTextTerm term) {
                if (term.isNot()) {
                    hasNegative.set(true);
                }
                return true;
            }
        });
        return (Boolean)hasNegative.get();
    }

    private Cursor flatten(FullTextExpression constraint, final AggregateIndexPlan plan, final Filter filter, final NodeState state, final String path) {
        if (constraint == null) {
            return null;
        }
        final AtomicReference result = new AtomicReference();
        constraint.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextContains contains) {
                return contains.getBase().accept(this);
            }

            @Override
            public boolean visit(FullTextTerm term) {
                QueryIndex.IndexPlan p = plan.getPlan(path);
                result.set(AggregateIndex.this.newAggregationCursor(p, state));
                return true;
            }

            @Override
            public boolean visit(FullTextAnd and) {
                Iterator<FullTextExpression> iterator = and.list.iterator();
                int index = 0;
                Cursor c = AggregateIndex.this.flatten(iterator.next(), plan, filter, state, path + " and(" + index + ")");
                while (iterator.hasNext()) {
                    FullTextExpression input = iterator.next();
                    Cursor newC = AggregateIndex.this.flatten(input, plan, filter, state, path + " and(" + ++index + ")");
                    c = Cursors.newIntersectionCursor((Cursor)c, (Cursor)newC, (QueryLimits)filter.getQueryLimits());
                }
                result.set(c);
                return true;
            }

            @Override
            public boolean visit(FullTextOr or) {
                final int[] index = new int[1];
                List cursors = Lists.transform(or.list, (Function)new Function<FullTextExpression, Cursor>(){

                    public Cursor apply(FullTextExpression input) {
                        int n = index[0];
                        index[0] = n + 1;
                        return AggregateIndex.this.flatten(input, plan, filter, state, path + " or(" + n + ")");
                    }
                });
                result.set(Cursors.newConcatCursor((List)cursors, (QueryLimits)filter.getQueryLimits()));
                return true;
            }
        });
        return (Cursor)result.get();
    }

    private void collectCombinedPlan(FullTextExpression constraint, final Filter filter, final List<QueryIndex.OrderEntry> sortOrder, final NodeState state, final AggregateIndexPlan target, final String path) {
        constraint.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextContains contains) {
                return contains.getBase().accept(this);
            }

            @Override
            public boolean visit(FullTextTerm term) {
                List<QueryIndex.IndexPlan> list = AggregateIndex.this.baseIndex.getPlans(AggregateIndex.newAggregationFilter(filter, term), sortOrder, state);
                target.setPlan(path, list);
                return true;
            }

            @Override
            public boolean visit(FullTextAnd and) {
                int index = 0;
                for (FullTextExpression input : and.list) {
                    AggregateIndex.this.collectCombinedPlan(input, filter, sortOrder, state, target, path + " and(" + index + ")");
                    ++index;
                }
                return true;
            }

            @Override
            public boolean visit(FullTextOr or) {
                int index = 0;
                for (FullTextExpression input : or.list) {
                    AggregateIndex.this.collectCombinedPlan(input, filter, sortOrder, state, target, path + " or(" + index + ")");
                    ++index;
                }
                return true;
            }
        });
    }

    private Cursor newAggregationCursor(QueryIndex.IndexPlan plan, NodeState rootState) {
        Cursor c = this.baseIndex.query(plan, rootState);
        return new AggregationCursor(c, this.getNodeAggregator(), rootState);
    }

    private static Filter newAggregationFilter(Filter filter, FullTextExpression exp) {
        FilterImpl f = new FilterImpl(filter);
        f.setMatchesAllTypes(true);
        if (exp != null) {
            f.setFullTextConstraint(exp);
        }
        return f;
    }

    @Override
    public String getPlan(Filter filter, NodeState rootState) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    @Override
    public String getPlanDescription(QueryIndex.IndexPlan plan, NodeState root) {
        if (this.baseIndex == null) {
            return "aggregate no-index";
        }
        StringBuilder buff = new StringBuilder("aggregate ");
        if (this.getNodeAggregator() == null) {
            buff.append(this.baseIndex.getPlanDescription(plan, root));
            return buff.toString();
        }
        if (!(plan instanceof AggregateIndexPlan)) {
            buff.append(this.baseIndex.getPlanDescription(plan, root));
            return buff.toString();
        }
        AggregateIndexPlan aggPlan = (AggregateIndexPlan)plan;
        for (QueryIndex.IndexPlan p : aggPlan.getPlans()) {
            if (p == null) continue;
            buff.append(this.baseIndex.getPlanDescription(p, root));
            buff.append(" ");
        }
        return buff.toString();
    }

    @Override
    public String getIndexName() {
        if (this.baseIndex == null) {
            return "aggregate no-index";
        }
        return "aggregate " + this.baseIndex.getIndexName();
    }

    @Override
    public QueryIndex.NodeAggregator getNodeAggregator() {
        return this.baseIndex.getNodeAggregator();
    }
}

