/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dwg;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.StringUtil;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DWGParser
extends AbstractParser {
    private static final long serialVersionUID = -7744232583079169119L;
    private static MediaType TYPE = MediaType.image("vnd.dwg");
    private static final Property[] HEADER_PROPERTIES_ENTRIES = new Property[]{TikaCoreProperties.TITLE, TikaCoreProperties.TRANSITION_SUBJECT_TO_DC_DESCRIPTION, TikaCoreProperties.CREATOR, TikaCoreProperties.TRANSITION_KEYWORDS_TO_DC_SUBJECT, TikaCoreProperties.COMMENTS, TikaCoreProperties.MODIFIER, null, TikaCoreProperties.RELATION};
    private static final Property[] HEADER_2000_PROPERTIES_ENTRIES = new Property[]{null, TikaCoreProperties.RELATION, TikaCoreProperties.TITLE, TikaCoreProperties.TRANSITION_SUBJECT_TO_DC_DESCRIPTION, TikaCoreProperties.CREATOR, null, TikaCoreProperties.COMMENTS, TikaCoreProperties.TRANSITION_KEYWORDS_TO_DC_SUBJECT, TikaCoreProperties.MODIFIER};
    private static final String HEADER_2000_PROPERTIES_MARKER_STR = "DWGPROPS COOKIE";
    private static final byte[] HEADER_2000_PROPERTIES_MARKER = new byte["DWGPROPS COOKIE".length()];
    private static final int CUSTOM_PROPERTIES_SKIP = 20;
    private static final int[] CUSTOM_PROPERTIES_ALT_PADDING_VALUES;

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Collections.singleton(TYPE);
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        byte[] header = new byte[128];
        IOUtils.readFully(stream, header);
        String version = new String(header, 0, 6, "US-ASCII");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        if (version.equals("AC1015")) {
            metadata.set("Content-Type", TYPE.toString());
            if (this.skipTo2000PropertyInfoSection(stream, header)) {
                this.get2000Props(stream, metadata, xhtml);
            }
        } else if (version.equals("AC1018")) {
            metadata.set("Content-Type", TYPE.toString());
            if (this.skipToPropertyInfoSection(stream, header)) {
                this.get2004Props(stream, metadata, xhtml);
            }
        } else if (version.equals("AC1021") || version.equals("AC1024")) {
            metadata.set("Content-Type", TYPE.toString());
            if (this.skipToPropertyInfoSection(stream, header)) {
                this.get2007and2010Props(stream, metadata, xhtml);
            }
        } else {
            throw new TikaException("Unsupported AutoCAD drawing version: " + version);
        }
        xhtml.endDocument();
    }

    private void get2004Props(InputStream stream, Metadata metadata, XHTMLContentHandler xhtml) throws IOException, TikaException, SAXException {
        for (int i = 0; i < HEADER_PROPERTIES_ENTRIES.length; ++i) {
            String headerValue = this.read2004String(stream);
            this.handleHeader(i, headerValue, metadata, xhtml);
        }
        int customCount = this.skipToCustomProperties(stream);
        for (int i = 0; i < customCount; ++i) {
            String propName = this.read2004String(stream);
            String propValue = this.read2004String(stream);
            if (propName.length() <= 0 || propValue.length() <= 0) continue;
            metadata.add(propName, propValue);
        }
    }

    private String read2004String(InputStream stream) throws IOException, TikaException {
        int stringLen = EndianUtils.readUShortLE(stream);
        byte[] stringData = new byte[stringLen];
        IOUtils.readFully(stream, stringData);
        if (stringData[stringLen - 1] == 0) {
            --stringLen;
        }
        String value = StringUtil.getFromCompressedUnicode(stringData, 0, stringLen);
        return value;
    }

    private void get2007and2010Props(InputStream stream, Metadata metadata, XHTMLContentHandler xhtml) throws IOException, TikaException, SAXException {
        for (int i = 0; i < HEADER_PROPERTIES_ENTRIES.length; ++i) {
            String headerValue = this.read2007and2010String(stream);
            this.handleHeader(i, headerValue, metadata, xhtml);
        }
        int customCount = this.skipToCustomProperties(stream);
        for (int i = 0; i < customCount; ++i) {
            String propName = this.read2007and2010String(stream);
            String propValue = this.read2007and2010String(stream);
            if (propName.length() <= 0 || propValue.length() <= 0) continue;
            metadata.add(propName, propValue);
        }
    }

    private String read2007and2010String(InputStream stream) throws IOException, TikaException {
        int stringLen = EndianUtils.readUShortLE(stream);
        byte[] stringData = new byte[stringLen * 2];
        IOUtils.readFully(stream, stringData);
        String value = StringUtil.getFromUnicodeLE(stringData);
        if (value.charAt(value.length() - 1) == '\u0000') {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private void get2000Props(InputStream stream, Metadata metadata, XHTMLContentHandler xhtml) throws IOException, TikaException, SAXException {
        for (int propCount = 0; propCount < 30; ++propCount) {
            int splitAt;
            int propIdx = EndianUtils.readUShortLE(stream);
            int length = EndianUtils.readUShortLE(stream);
            int valueType = stream.read();
            if (propIdx == 40) {
                length = 25;
            } else if (propIdx == 90) break;
            byte[] value = new byte[length];
            IOUtils.readFully(stream, value);
            if (valueType != 30) continue;
            String val = StringUtil.getFromCompressedUnicode(value, 0, length);
            if (propIdx < HEADER_2000_PROPERTIES_ENTRIES.length) {
                metadata.add(HEADER_2000_PROPERTIES_ENTRIES[propIdx], val);
                xhtml.element("p", val);
                continue;
            }
            if (propIdx != 300 || (splitAt = val.indexOf(61)) <= -1) continue;
            String propName = val.substring(0, splitAt);
            String propVal = val.substring(splitAt + 1);
            metadata.add(propName, propVal);
        }
    }

    private void handleHeader(int headerNumber, String value, Metadata metadata, XHTMLContentHandler xhtml) throws SAXException {
        if (value == null || value.length() == 0) {
            return;
        }
        Property headerProp = HEADER_PROPERTIES_ENTRIES[headerNumber];
        if (headerProp != null) {
            metadata.set(headerProp, value);
        }
        xhtml.element("p", value);
    }

    private boolean skipToPropertyInfoSection(InputStream stream, byte[] header) throws IOException, TikaException {
        long offsetToSection = EndianUtils.getLongLE(header, 32);
        if (offsetToSection > 0xA00000L) {
            offsetToSection = 0L;
        }
        long toSkip = offsetToSection - (long)header.length;
        if (offsetToSection == 0L) {
            return false;
        }
        long skipped = IOUtils.skipFully(stream, toSkip);
        if (skipped != toSkip) {
            throw new TikaException("Failed to skip: " + toSkip + " bytes; skipped: " + skipped);
        }
        return true;
    }

    private boolean skipTo2000PropertyInfoSection(InputStream stream, byte[] header) throws IOException {
        int val = 0;
        while (val != -1) {
            val = stream.read();
            if (val != HEADER_2000_PROPERTIES_MARKER[0]) continue;
            boolean going = true;
            for (int i = 1; i < HEADER_2000_PROPERTIES_MARKER.length && going; ++i) {
                val = stream.read();
                if (val == HEADER_2000_PROPERTIES_MARKER[i]) continue;
                going = false;
            }
            if (!going) continue;
            return true;
        }
        return false;
    }

    private int skipToCustomProperties(InputStream stream) throws IOException, TikaException {
        byte[] padding = new byte[4];
        IOUtils.readFully(stream, padding);
        if (padding[0] == 0 && padding[1] == 0 && padding[2] == 0 && padding[3] == 0 || padding[0] == CUSTOM_PROPERTIES_ALT_PADDING_VALUES[0] && padding[1] == CUSTOM_PROPERTIES_ALT_PADDING_VALUES[1] && padding[2] == CUSTOM_PROPERTIES_ALT_PADDING_VALUES[2] && padding[3] == CUSTOM_PROPERTIES_ALT_PADDING_VALUES[3]) {
            padding = new byte[20];
            IOUtils.readFully(stream, padding);
            int count = EndianUtils.readUShortLE(stream);
            if (count > 0 && count < 127) {
                return count;
            }
            return 0;
        }
        return 0;
    }

    static {
        StringUtil.putCompressedUnicode(HEADER_2000_PROPERTIES_MARKER_STR, HEADER_2000_PROPERTIES_MARKER, 0);
        CUSTOM_PROPERTIES_ALT_PADDING_VALUES = new int[]{2, 0, 0, 0};
    }
}

