/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2006, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be coveredby   */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm.msg;

import java.util.Date;

/**
 * @author  <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
 * @version $Revision: #1 $
 */
public final class NCDate extends NCType
{
	// --------------------------------------------------------------------------- Private Variables

	/** long value */
	private final long millis; 

	// -------------------------------------------------------------------------- Public Constructor

	/** Public constructor
	 * @param value date value
	 */
	public NCDate(Date value)
	{
		this.millis = value.getTime();
	}

	/** Public constructor
	 * @param millis date value
	 */
	public NCDate(long millis)
	{
		this.millis = millis;
	}

	// ------------------------------------------------------------------------------ Public Methods

	/** @return date value */
	public long millis()
	{
		return millis;
	}

	/** @return date value */
	public Date date()
	{
		return new Date(millis);
	}

	@Override
	public int getType()
	{
		return NCType.TYPE_DATE;
	}

	@Override
	public int hashCode()
	{
		return (int) (millis ^ (millis >>> 32));
	}

	@Override
	public boolean equals(Object other)
	{
		if (other != null  &&  other instanceof NCDate)
		{
			NCDate otherDate = (NCDate) other;
			return millis() == otherDate.millis();
		}
		return false;
	}

	@Override
	public String toString()
	{
		return "NCDate <" + new Date(millis) + ">";
	}
}
