// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2012 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.core.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

import com.adobe.xmp.core.XMPException;
import com.adobe.xmp.core.XMPMetadata;
import com.adobe.xmp.core.serializer.impl.SerializerImpl;


/**
 * Implementation of XMPSerializer to serialize RDF/XML.
 *
 * @author smakswit
 */
public class RDFXMLSerializer implements XMPSerializer
{
	/** the actual implementation that is used */
	private SerializerImpl delegate = new SerializerImpl();
	
	
	/**
	 * @see XMPSerializer#serialize(XMPMetadata, OutputStream, Map)
	 */
	public void serialize(
		XMPMetadata xmp,
		OutputStream out,
		Map<String, Object> serializeContext)
			throws IOException, XMPException
	{
		delegate.serialize(xmp, out, serializeContext);
	}

	
	/**
	 * @see XMPSerializer#serializeToString(XMPMetadata, Map)
	 */
	public String serializeToString(
		XMPMetadata xmp,
		Map<String, Object> serializeContext)
			throws IOException, XMPException
	{
		return delegate.serializeToString(xmp, serializeContext);
	}

	
	/**
	 * @see XMPSerializer#serializeToBuffer(XMPMetadata, Map)
	 */
	public byte[] serializeToBuffer(
		XMPMetadata xmp,
		Map<String, Object> serializeContext)
			throws IOException, XMPException
	{
		return delegate.serializeToBuffer(xmp, serializeContext);
	}
}
