/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.contentsync.config;

import java.util.Iterator;

/**
 * The {@code Config} interface provides access to
 * content sync configurations.
 */
public interface Config {

    /**
     * Get the config's path.
	 * @return the path.
     */
	String getPath();

	/**
	 * Get the config's name.
	 * @return the name
	 */
	String getName();

	/**
	 * Get the authorizable's id that is authorized to read
	 * and write the cache.
	 * @return the authorizable id
	 */
	String getAuthorizable();

	/**
	 * Get the user's id to be used for content updates
	 * (in case it's not a personalized config).
	 * @return the user id
	 */
	String getUpdateUser();

	/**
	 * Get the list of configuration entries.
	 * @return the entries.
	 */
	Iterator<ConfigEntry> getEntries();
}
