/*
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.graphics.chart;

import java.awt.Color;

import com.day.cq.graphics.Graph;
import com.day.image.Layer;
import com.day.image.LineStyle;

/**
 * @author fmeschbe
 */
public class Grid {
    private final LineStyle lineStyle;
    private final Graph graph;

    public Grid(Graph graph, LineStyle lineStyle) {
	this.lineStyle = lineStyle;
	this.graph = graph;
    }

    public void draw(Layer layer, boolean doDraw) {

	// ignore if not drawing or incompletely configured
	if (!doDraw || graph == null) return;

	// additional lines for fancy grid style and bar charts
	boolean fancyBars = (lineStyle.getStyle() == LineStyle.STYLE_FANCY &&
	    graph.getChart() instanceof BarChart);

	// the line style for fancy bar charts
	LineStyle style = null;

	if (fancyBars) {
	    style = new LineStyle(Color.black,
		(float)(graph.getXAxis().getRangescale() * graph.getXAxis().getRangestep()),
		1, 1);
	}

	int w = layer.getWidth();
	for (int num=0; num <= graph.getYAxis().numticks; num++) {
	    int y = graph.getYAxis().tickpos[num];
	    if (y < layer.getHeight()) {
		layer.setLineStyle(lineStyle);
		layer.drawLine(0, y, w-1, y);
		if (fancyBars) {
		    layer.setLineStyle(style);
		    layer.drawLine(0, y, w-1, y);
		}
	    }
	}
    }

    public LineStyle getLineStyle() {
	return lineStyle;
    }
}
