/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

import javax.jcr.Session;

/**
 * Handles replication imports.
 */
public interface ReplicationReceiver {

    /**
     * Receives a durbo replication and performs the respective actions.
     *
     * @param session repository session to use for importing
     * @param action the replication action to perform
     * @param in input stream of the durbo serialized data
     * @param size size of the input stream
     * @param out a writer used for response messages
     * @throws ReplicationException of an error occurrs
     * @throws IOException if an I/O error occurs while writing to the writer
     */
    void receive(Session session, ReplicationAction action, InputStream in, long size, Writer out)
            throws ReplicationException, IOException;

    /**
     * Receives a durbo replication and performs the respective actions.
     *
     * @param session repository session to use for importing
     * @param action the replication action to perform
     * @param in input stream of the durbo serialized data
     * @param size size of the input stream
     * @param out a writer used for response messages
     * @param install if action is ACTIVATE this controls if a package should be also installed
     * @throws ReplicationException of an error occurrs
     * @throws IOException if an I/O error occurs while writing to the writer
     */
    void receive(Session session, ReplicationAction action, InputStream in, long size, Writer out, boolean install)
            throws ReplicationException, IOException;

    /**
     * Receives a durbo replication and performs the respective actions.
     *
     * @param session repository session to use for importing
     * @param action the replication action to perform
     * @param in input stream of the durbo serialized data
     * @param size size of the input stream
     * @param out a writer used for response messages
     * @param install if action is ACTIVATE this controls if a package should be also installed
     * @param binaryLess if receiver has to handle binary less imports
     * @throws ReplicationException of an error occurrs
     * @throws IOException if an I/O error occurs while writing to the writer
     */
    void receive(Session session, ReplicationAction action, InputStream in, long size, Writer out, boolean install, boolean binaryLess)
            throws ReplicationException, IOException;
}