/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.facets.buckets;

import javax.jcr.RepositoryException;
import javax.jcr.Value;

import com.day.cq.search.Predicate;

/**
 * <code>PredefinedBucket</code> is a bucket that is backed by some
 * definition and decides itself which values to {@link #acceptValue(Value)
 * accept}.
 * 
 * @since 5.2
 */
public abstract class PredefinedBucket extends SimpleBucket {

    public PredefinedBucket(Predicate predicate, String name) {
        // use name for the bucket "display" value
        super(predicate, name);
    }

    /**
     * Accepts the <code>value</code> and increments the counter of this bucket
     * if the <code>value</code> matches this buckets definition.
     *
     * @param value the value to accept.
     * @throws RepositoryException if an error occurs while reading from the
     *          repository. 
     */
    public abstract void acceptValue(Value value) throws RepositoryException;
}
