package com.day.cq.wcm.designimporter.parser.taghandlers.factory;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;
import com.day.cq.wcm.designimporter.parser.taghandlers.ImgTagHandler;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.Constants;

/**
 * The TagHandlerFactory that rolls out {@link ImgTagHandler} instances
 */
@Service
@Component(metatype = true)
@Properties({
        @Property(name = Constants.SERVICE_RANKING, intValue = 5000, propertyPrivate = false),
        @Property(name = TagHandlerFactory.PN_TAGPATTERN, value = ImgTagHandlerFactory.TAG_PATTERN),
        @Property(name = "service.factoryPid", value = "com.day.cq.wcm.designimporter.api.TagHandler")
})
public class ImgTagHandlerFactory implements TagHandlerFactory {

    static public final String TAG_PATTERN = "<img(?!.* data-cq-component=\"(?i)image\").*>";

    /**
     * @deprecated Usage of externalizer has been removed (keeping this field for backwards compatibility)
     */
    @Reference
    @Deprecated
    Externalizer externalizer;

    @Reference
    private XSSAPI xssAPI;

    public TagHandler create() {
        ImgTagHandler imgTagHandler = new ImgTagHandler();
        imgTagHandler.setXssAPI(xssAPI);
        return imgTagHandler;
    }
}
