/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * <code>Task</code> implements a future task that allows to wait for the result
 * of the task.
 */
class Task extends FutureTask<Object> {

    /**
     * Marker task that indicates the statistics instance to shut down. 
     */
    static final Task SHUTDOWN = new Task(null, null);

    private final Session session;

    private final Entry entry;

    public Task(final Session session, final Entry entry) {
        super(new Callable<Object>() {
            public Object call() throws Exception {
                return null;
            }
        });
        this.session = session;
        this.entry = entry;
    }

    public void performWork() throws RepositoryException {
        entry.write(session);
    }

    public void setDone() {
        set(null);
    }

    @Override
    public void setException(Throwable t) {
        super.setException(t);
    }
}
