/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.types.DateParserNoTimeZone;
import com.adobe.internal.pdftoolkit.core.types.NonConformingDateParser;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ASDate
extends ASObject
implements Comparable {
    private static final DecimalFormat yearFormat;
    private static final DecimalFormat dateFormat;
    private static ArrayList<NonConformingDateParser> fallbackDateParsers;
    private static final String datePatternString = "^(D:)?(\\d{4})(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?(?:([\\+-Z])(?:(\\d{2})')?(?:(\\d{2})')?)?\\z";
    private static final Pattern datePattern;
    private GregorianCalendar calendar = (GregorianCalendar)Calendar.getInstance(Locale.US);
    private ASString dateString;
    private boolean dateStringValid = true;
    private boolean timeZoneSet = true;
    private static final String datePatternStringNoTZ = "^(D:)?(\\d{4})(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?";
    private static final Pattern datePatternNoTZ;

    public ASDate() {
        this.calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        this.calendar.setTimeZone(TimeZone.getDefault());
        this.calendar.set(14, 0);
    }

    public ASDate(Date date) {
        this();
        this.calendar.setTime(date);
        this.calendar.set(14, 0);
    }

    public ASDate(Date date, TimeZone zone) {
        this();
        this.calendar.setTimeZone(zone);
        this.calendar.setTime(date);
        this.calendar.set(14, 0);
    }

    public ASDate(String dateString) throws PDFParseException {
        this(new ASString(dateString));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASDate(ASString dateString) throws PDFParseException {
        this();
        String s = dateString.toString();
        try {
            this.parse(s);
        }
        catch (PDFParseException e) {
            this.dateStringValid = false;
            GregorianCalendar fallbackCalendar = null;
            for (NonConformingDateParser dateParser : fallbackDateParsers) {
                fallbackCalendar = dateParser.parse(this.calendar, s);
                if (fallbackCalendar == null) continue;
                this.calendar = fallbackCalendar;
                this.dateStringValid = true;
                this.timeZoneSet = dateParser.hasTimeZone(fallbackCalendar, s);
                break;
            }
        }
        this.dateString = dateString;
    }

    public boolean isDateValid() {
        return this.dateStringValid;
    }

    public int compareTo(Object obj) {
        return this.compareTo((ASDate)obj);
    }

    public int compareTo(ASDate otherASDate) {
        Date date = this.toDate();
        Date otherDate = otherASDate.toDate();
        if (date == null) {
            if (otherDate == null) {
                return 0;
            }
            return -1;
        }
        if (otherDate == null) {
            return 1;
        }
        return date.compareTo(otherDate);
    }

    public boolean before(ASDate otherDate) {
        return this.compareTo(otherDate) < 0;
    }

    public boolean after(ASDate otherDate) {
        return this.compareTo(otherDate) > 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ASDate)) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.toDate().hashCode();
    }

    public String asString() {
        return this.getDateString().asString();
    }

    public String toString() {
        return this.getDateString().toString();
    }

    public String toStringTimezoneUnaware() {
        String orig = this.getDateString().toString();
        if (orig == null) {
            return null;
        }
        Matcher matcher = datePatternNoTZ.matcher(orig);
        if (!matcher.find()) {
            return null;
        }
        int year = Integer.parseInt(matcher.group(2));
        int month = matcher.group(3) == null ? 1 : Integer.parseInt(matcher.group(3));
        int date = matcher.group(4) == null ? 1 : Integer.parseInt(matcher.group(4));
        int hour = matcher.group(5) == null ? 0 : Integer.parseInt(matcher.group(5));
        int minute = matcher.group(6) == null ? 0 : Integer.parseInt(matcher.group(6));
        int second = matcher.group(7) == null ? 0 : Integer.parseInt(matcher.group(7));
        GregorianCalendar calNoTZ = (GregorianCalendar)Calendar.getInstance(Locale.US);
        calNoTZ.set(year, month - 1, date, hour, minute, second);
        StringBuilder result = new StringBuilder("D:");
        result.append(yearFormat.format(calNoTZ.get(1)));
        result.append(dateFormat.format(calNoTZ.get(2) + 1));
        result.append(dateFormat.format(calNoTZ.get(5)));
        result.append(dateFormat.format(calNoTZ.get(11)));
        result.append(dateFormat.format(calNoTZ.get(12)));
        result.append(dateFormat.format(calNoTZ.get(13)));
        return result.toString();
    }

    public ASDate(String dateString, TimeZone zone) throws PDFParseException {
        this(dateString);
        this.calendar.setTimeZone(zone);
    }

    public Date toDate() {
        if (!this.dateStringValid) {
            return null;
        }
        return this.calendar.getTime();
    }

    public boolean hasTimeZone() {
        return this.timeZoneSet;
    }

    public TimeZone getTimeZone() {
        if (!this.dateStringValid) {
            return null;
        }
        return this.calendar.getTimeZone();
    }

    private void parse(String s) throws PDFParseException {
        Matcher matcher = datePattern.matcher(s);
        if (!matcher.find()) {
            throw new PDFParseException("Invalid date format - " + s);
        }
        int year = Integer.parseInt(matcher.group(2));
        int month = matcher.group(3) == null ? 1 : Integer.parseInt(matcher.group(3));
        int date = matcher.group(4) == null ? 1 : Integer.parseInt(matcher.group(4));
        int hour = matcher.group(5) == null ? 0 : Integer.parseInt(matcher.group(5));
        int minute = matcher.group(6) == null ? 0 : Integer.parseInt(matcher.group(6));
        int second = matcher.group(7) == null ? 0 : Integer.parseInt(matcher.group(7));
        boolean hasGMT = matcher.group(8) != null;
        int gmtSign = 0;
        int offsetGMTHour = 0;
        int offsetGMTMinute = 0;
        if (hasGMT) {
            gmtSign = matcher.group(8).equals("-") ? -1 : 1;
            offsetGMTHour = matcher.group(9) == null ? 0 : Integer.parseInt(matcher.group(9));
            offsetGMTMinute = matcher.group(10) == null ? 0 : Integer.parseInt(matcher.group(10));
        }
        this.calendar.clear();
        if (hasGMT) {
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            timeZone.setRawOffset(gmtSign * (offsetGMTHour * 60 + offsetGMTMinute) * 60 * 1000);
            this.calendar.setTimeZone(timeZone);
        }
        this.timeZoneSet = hasGMT;
        this.calendar.set(year, month - 1, date, hour, minute, second);
    }

    private ASString getDateString() {
        if (this.dateString == null) {
            this.dateString = new ASString(this.makeString());
        }
        return this.dateString;
    }

    private String makeString() {
        StringBuilder date = new StringBuilder("D:");
        date.append(yearFormat.format(this.calendar.get(1)));
        date.append(dateFormat.format(this.calendar.get(2) + 1));
        date.append(dateFormat.format(this.calendar.get(5)));
        date.append(dateFormat.format(this.calendar.get(11)));
        date.append(dateFormat.format(this.calendar.get(12)));
        date.append(dateFormat.format(this.calendar.get(13)));
        TimeZone zone = this.calendar.getTimeZone();
        int gmtOffsetMilli = zone.getOffset(this.calendar.getTime().getTime());
        int gmtOffsetHour = gmtOffsetMilli / 3600000;
        int gmtOffsetMinute = Math.abs(gmtOffsetMilli % 3600000 / 60000);
        if (gmtOffsetHour == 0 && gmtOffsetMinute == 0) {
            date.append('Z');
        } else {
            if (gmtOffsetHour < 0) {
                date.append('-');
                date.append(dateFormat.format(-gmtOffsetHour));
            } else {
                date.append('+');
                date.append(dateFormat.format(gmtOffsetHour));
            }
            date.append('\'');
            date.append(dateFormat.format(gmtOffsetMinute));
            date.append('\'');
        }
        return date.toString();
    }

    @Override
    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        this.getDateString().write(outputByteStream);
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        dfs.setZeroDigit('0');
        dfs.setDecimalSeparator('.');
        dfs.setMinusSign('-');
        yearFormat = new DecimalFormat("####", dfs);
        yearFormat.setMinimumIntegerDigits(4);
        yearFormat.setGroupingUsed(false);
        dateFormat = new DecimalFormat("#", dfs);
        dateFormat.setMinimumIntegerDigits(2);
        dateFormat.setGroupingUsed(false);
        fallbackDateParsers = new ArrayList();
        fallbackDateParsers.add(DateParserNoTimeZone.getInstance());
        datePattern = Pattern.compile(datePatternString);
        datePatternNoTZ = Pattern.compile(datePatternStringNoTZ);
    }
}

