/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.xfa.text.AFEElement;
import com.adobe.xfa.text.DispEmbed;
import com.adobe.xfa.text.DispLineRaw;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.MappingManager;
import com.adobe.xfa.text.TextContext;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.Storage;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

class AFERun
implements AttributedRun {
    private Storage<AFEElement> mElements;
    private TextContext mContext;
    private int mInstance;
    private int mEvent;
    private boolean mMapRequired = false;
    private static final AtomicInteger gNextDebugInstance = new AtomicInteger();
    private static final boolean gEnableDebugging = false;

    AFERun(TextContext context) {
    }

    void load(DispLineRaw line) {
        StringBuilder debugMsg = null;
        if (this.mContext != null) {
            this.mInstance = gNextDebugInstance.incrementAndGet();
            debugMsg = this.startDebug("create");
            debugMsg.append("[");
        }
        int charCount = line.getCharCount();
        if (this.mElements == null) {
            this.mElements = new Storage(charCount);
        } else {
            this.mElements.setSize(0);
        }
        int runIndex = 0;
        int runCharLimit = 0;
        AFEElement prevElement = null;
        DispRun dispRun = null;
        DispRun prevRun = null;
        MappingManager mappingManager = line.getFormatInfo().getMappingManager();
        TextContext context = line.display().getContext();
        for (int i = 0; i < charCount; ++i) {
            DispEmbed embed;
            if (debugMsg != null && i > 0) {
                debugMsg.append(", ");
            }
            int bidiLevel = 0;
            if (mappingManager != null) {
                bidiLevel = mappingManager.getLevel(i);
            }
            if ((embed = line.isObject(i)) != null) {
                AFEElement element = new AFEElement(context, embed.getEmbed(), i);
                element.populateEmbed(dispRun, bidiLevel);
                this.mElements.add(element);
                prevRun = null;
                prevElement = null;
                if (debugMsg == null) continue;
                debugMsg.append(" object (");
                debugMsg.append(element.getEmbed().toString());
                debugMsg.append(")");
                continue;
            }
            if (i >= runCharLimit) {
                dispRun = line.getRun(runIndex);
                runCharLimit = dispRun.getMapIndex() + dispRun.getMapLength();
                ++runIndex;
            }
            int c = line.getChar(i);
            AFEElement element = new AFEElement(context, c, i);
            element.populateChar(prevElement, dispRun, prevRun, bidiLevel);
            this.mElements.add(element);
            prevElement = element;
            prevRun = dispRun;
            if (debugMsg == null) continue;
            if (c == 39) {
                debugMsg.append("'\\''");
                continue;
            }
            if (c >= 32 && c < 127) {
                debugMsg.append('\'');
                debugMsg.append((char)c);
                debugMsg.append('\'');
                continue;
            }
            debugMsg.append(Units.hexToString(c));
        }
        if (debugMsg != null) {
            debugMsg.append(']');
            this.mContext.debug(debugMsg.toString());
        }
    }

    int getSize() {
        return this.mElements.size();
    }

    AFEElement getElement(int position) {
        return this.e(position);
    }

    boolean isMapRequired() {
        return this.mMapRequired;
    }

    @Override
    public void adjustPlacementAndAdvance(int position, double xPlacementDelta, double yPlacementDelta, double xAdvanceDelta, double yAdvanceDelta) {
        AFEElement element = null;
        if (xPlacementDelta != 0.0 || yPlacementDelta != 0.0 || xAdvanceDelta != 0.0 || yAdvanceDelta != 0.0) {
            element = this.e(position);
            element.adjustPlacementAndAdvance(xPlacementDelta, yPlacementDelta, xAdvanceDelta, yAdvanceDelta);
            this.debugElementPlacementAndAdvance(element, position, "adjustPlacementAndAdvance");
        }
    }

    @Override
    public int elementAt(int position) {
        return this.e(position).elementAt();
    }

    @Override
    public Object getElementStyle(int position, ElementAttribute attribute) {
        return this.e(position).getElementStyle(attribute);
    }

    @Override
    public double getElementXAdvance(int position) {
        return this.e(position).getElementXAdvance();
    }

    @Override
    public double getElementXPlacement(int position) {
        return this.e(position).getElementXPlacement();
    }

    @Override
    public double getElementYAdvance(int position) {
        return this.e(position).getElementYAdvance();
    }

    @Override
    public double getElementYPlacement(int position) {
        return this.e(position).getElementYPlacement();
    }

    @Override
    public Object getInterElementStyleBefore(int position, InterElementAttribute attribute) {
        return this.e(position).getInterElementStyleBefore(attribute);
    }

    @Override
    public int getSubrunLimit(int start, int limit, ElementAttribute attribute) {
        AFEElement first = this.e(start);
        for (int test = start + 1; test < limit; ++test) {
            if (first.matchAttr(this.e(test), attribute)) continue;
            return test;
        }
        return limit;
    }

    @Override
    public int getSubrunLimit(int start, int limit, Set attributes) {
        AFEElement first = this.e(start);
        for (int test = start + 1; test < limit; ++test) {
            if (first.matchAttr(this.e(test), attributes)) continue;
            return test;
        }
        return limit;
    }

    @Override
    public void remove(int position) {
        this.mElements.remove(position);
        this.mMapRequired = true;
    }

    @Override
    public void replace(int[] positions, int[] elementIDs) {
        this.replaceManyWithMany(positions, elementIDs);
    }

    @Override
    public void replace(int position, int elementID) {
        this.replaceOneWithOne(position, elementID);
    }

    @Override
    public void replace(int position, int[] elementIDs) {
        this.replaceOneWithMany(position, elementIDs);
    }

    @Override
    public void replace(int[] positions, int elementID) {
        this.replaceManyWithOne(positions, elementID);
    }

    @Override
    public void replace(int start, int limit, int elementID) {
        this.replaceRangeWithOne(start, limit, elementID);
    }

    @Override
    public void setElementPlacementAndAdvance(int position, double xPlacement, double yPlacement, double xAdvance, double yAdvance) {
        AFEElement element = this.e(position);
        element.setElementPlacementAndAdvance(xPlacement, yPlacement, xAdvance, yAdvance);
        this.debugElementPlacementAndAdvance(element, position, "setElementPlacementAndAdvance");
    }

    @Override
    public void setElementStyle(int position, ElementAttribute attribute, Object value) {
        this.debugElementStyle(position, position + 1, attribute, value);
        this.e(position).setElementStyle(attribute, value);
    }

    @Override
    public void setElementStyle(int start, int limit, ElementAttribute attribute, Object value) {
        this.debugElementStyle(start, limit, attribute, value);
        for (int i = start; i < limit; ++i) {
            this.e(i).setElementStyle(attribute, value);
        }
    }

    @Override
    public void setInterElementStyleBefore(int position, InterElementAttribute attribute, Object value) {
        this.debugInterElementStyle(position, position + 1, attribute, value);
        this.e(position).setInterElementStyleBefore(attribute, value);
    }

    @Override
    public void setInterElementStyleBefore(int start, int limit, InterElementAttribute attribute, Object value) {
        this.debugInterElementStyle(start, limit, attribute, value);
        for (int i = start; i < limit; ++i) {
            this.e(i).setInterElementStyleBefore(attribute, value);
        }
    }

    @Override
    public void startWorkingWithPositions(int start, int limit) {
        if (this.mContext != null) {
            StringBuilder debugMsg = this.startDebug("startWorkingWithPositions");
            debugMsg.append('[');
            AFERun.debugInt(debugMsg, start);
            debugMsg.append('-');
            AFERun.debugInt(debugMsg, limit - 1);
            debugMsg.append(']');
            this.mContext.debug(debugMsg.toString());
        }
        for (int i = start; i < limit; ++i) {
            this.e(i).startWorkingWithPositions();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Run:\n");
        for (int i = 0; i < this.mElements.size(); ++i) {
            result.append("  (");
            result.append(this.e(i).toString());
            result.append(")\n");
        }
        return result.toString();
    }

    private AFEElement e(int position) {
        assert (position < this.mElements.size());
        return (AFEElement)this.mElements.get(position);
    }

    private void insert(int position, int[] elementIDs) {
        AFEElement sample = this.e(position);
        sample.setElement(elementIDs[0], true);
        sample.setInMultiple(true);
        for (int i = 1; i < elementIDs.length; ++i) {
            AFEElement insert = new AFEElement(sample);
            insert.setElement(elementIDs[i], true);
            this.mElements.add(position, insert);
            ++position;
        }
        this.mMapRequired = true;
    }

    private void remove(int[] positions) {
        for (int i = positions.length; i > 1; --i) {
            this.mElements.remove(positions[--i]);
        }
        this.mMapRequired = true;
    }

    private AFEElement removeRange(int start, int limit) {
        --limit;
        while (limit > start) {
            this.mElements.remove(limit);
            --limit;
        }
        this.mMapRequired = true;
        return this.e(start);
    }

    private void replaceManyWithMany(int[] positions, int[] elementIDs) {
        assert (positions.length > 0);
        if (elementIDs.length == 0) {
            int i = positions.length;
            while (i > 0) {
                this.remove(positions[--i]);
            }
        } else if (elementIDs.length == 1) {
            this.replaceManyWithOne(positions, elementIDs[0]);
        } else if (positions.length == 1) {
            this.replaceOneWithMany(positions[0], elementIDs);
        } else if (AFERun.isSequential(positions)) {
            this.replaceRangeWithMany(positions[0], positions[0] + positions.length, elementIDs);
        } else {
            this.mMapRequired = true;
            this.debugReplace(positions, elementIDs);
            this.remove(positions);
            this.insert(positions[0], elementIDs);
        }
    }

    private void replaceManyWithOne(int[] positions, int elementID) {
        assert (positions.length > 0);
        if (positions.length == 1) {
            this.replaceOneWithOne(positions[0], elementID);
        } else if (AFERun.isSequential(positions)) {
            this.replaceRangeWithOne(positions[0], positions[0] + positions.length, elementID);
        } else {
            assert (false);
            if (this.mContext != null) {
                int[] elementIDs = new int[]{elementID};
                this.debugReplace(positions, elementIDs);
            }
            this.remove(positions);
            AFEElement afeElement = this.e(positions[0]);
            afeElement.setElement(elementID, true);
            afeElement.setMapLength(afeElement.getMapLength() + positions.length - 1);
        }
    }

    private void replaceOneWithMany(int position, int[] elementIDs) {
        if (elementIDs.length == 0) {
            this.remove(position);
        } else if (elementIDs.length == 1) {
            this.replaceOneWithOne(position, elementIDs[0]);
        } else {
            if (this.mContext != null) {
                int[] positions = new int[]{position};
                this.debugReplace(positions, elementIDs);
            }
            this.insert(position, elementIDs);
        }
    }

    private void replaceOneWithOne(int position, int elementID) {
        if (this.mContext != null) {
            int[] positions = new int[]{position};
            int[] elementIDs = new int[]{elementID};
            this.debugReplace(positions, elementIDs);
        }
        this.e(position).setElement(elementID, false);
    }

    private void replaceRangeWithOne(int start, int limit, int elementID) {
        if (this.mContext != null) {
            int[] elementIDs = new int[]{elementID};
            this.debugReplaceRange(start, limit, elementIDs);
        }
        AFEElement keeper = this.removeRange(start, limit);
        keeper.setElement(elementID, true);
        keeper.setMapLength(keeper.getMapLength() + (limit - start - 1));
    }

    private void replaceRangeWithMany(int start, int limit, int[] elementIDs) {
        this.debugReplaceRange(start, limit, elementIDs);
        this.removeRange(start, limit);
        AFEElement keeper = this.removeRange(start, limit);
        keeper.setMapLength(keeper.getMapLength() + (limit - start - 1));
        this.insert(start, elementIDs);
    }

    private static boolean isSequential(int[] positions) {
        assert (positions.length > 0);
        int prev = positions[0];
        for (int i = 1; i < positions.length; ++i) {
            if (positions[i] == ++prev) continue;
            return false;
        }
        return true;
    }

    private StringBuilder startDebug(String event) {
        StringBuilder result = new StringBuilder();
        result.append(Units.intToString(this.mInstance, 4));
        result.append("(");
        result.append(Units.intToString(++this.mEvent, true));
        result.append(") ");
        result.append(event);
        result.append(": ");
        return result;
    }

    public void debugElementPlacementAndAdvance(AFEElement element, int position, String event) {
        if (this.mContext == null) {
            return;
        }
        StringBuilder debugMsg = this.startDebug(event);
        debugMsg.append("[");
        AFERun.debugInt(debugMsg, position);
        debugMsg.append("] placement (");
        debugMsg.append(Double.toString(element.getScaledXPlacement()));
        debugMsg.append(", ");
        debugMsg.append(Double.toString(element.getScaledYPlacement()));
        debugMsg.append(") advance (");
        debugMsg.append(Double.toString(element.getScaledXAdvance()));
        debugMsg.append(", ");
        debugMsg.append(Double.toString(element.getScaledYAdvance()));
        debugMsg.append(")");
        this.mContext.debug(debugMsg.toString());
    }

    private final void debugReplace(int[] positions, int[] elementIDs) {
        int i;
        if (this.mContext == null) {
            return;
        }
        StringBuilder debugMsg = this.startDebug("replace");
        debugMsg.append('[');
        int count = 0;
        int start = -1;
        int prev = Integer.MAX_VALUE;
        for (i = 0; i < positions.length; ++i) {
            int pos = positions[i];
            if (pos != prev + 1 && this.debugReplaceRange(debugMsg, count, start, prev)) {
                ++count;
                start = pos;
            }
            prev = pos;
            AFERun.debugInt(debugMsg, i, positions[i]);
        }
        this.debugReplaceRange(debugMsg, count, start, prev);
        debugMsg.append("] [");
        for (i = 0; i < elementIDs.length; ++i) {
            AFERun.debugHex(debugMsg, i, elementIDs[i]);
        }
        debugMsg.append(']');
        this.mContext.debug(debugMsg.toString());
    }

    private void debugReplaceRange(int start, int limit, int[] elementIDs) {
        if (this.mContext == null) {
            return;
        }
        int length = limit - start;
        int[] positions = new int[length];
        for (int i = 0; i < length; ++i) {
            positions[i] = start + i;
        }
        this.debugReplace(positions, elementIDs);
    }

    private final boolean debugReplaceRange(StringBuilder debugMsg, int count, int start, int end) {
        if (start < 0) {
            return false;
        }
        StringBuilder range = new StringBuilder();
        AFERun.debugInt(range, start);
        if (end > start) {
            range.append('-');
            AFERun.debugInt(range, end);
        }
        AFERun.debugElement(debugMsg, count, range.toString());
        return true;
    }

    private final void debugElementStyle(int start, int limit, ElementAttribute attribute, Object value) {
        this.debugStyle("setElementStyle", start, limit, attribute, value);
    }

    private final void debugInterElementStyle(int start, int limit, InterElementAttribute attribute, Object value) {
        this.debugStyle("setInterElementStyle", start, limit, attribute, value);
    }

    private final void debugStyle(String type, int start, int limit, Object attribute, Object value) {
        if (this.mContext == null) {
            return;
        }
        StringBuilder debugMsg = this.startDebug(type);
        debugMsg.append("[");
        AFERun.debugInt(debugMsg, start);
        if (limit - start > 1) {
            debugMsg.append("-");
            AFERun.debugInt(debugMsg, limit - 1);
        }
        debugMsg.append("] attribute (");
        debugMsg.append(attribute.toString());
        debugMsg.append(") value (");
        debugMsg.append(value.toString());
        debugMsg.append(")");
        this.mContext.debug(debugMsg.toString());
    }

    private static final void debugHex(StringBuilder result, int index, int value) {
        AFERun.debugElement(result, index, Units.hexToString(value, 4, "0x"));
    }

    private static final void debugInt(StringBuilder result, int value) {
        AFERun.debugInt(result, 0, value);
    }

    private static final void debugInt(StringBuilder result, int index, int value) {
        AFERun.debugElement(result, index, Units.intToString(value, 0));
    }

    private static final void debugElement(StringBuilder result, int index, String value) {
        if (index > 0) {
            result.append(", ");
        }
        result.append(value);
    }
}

