/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.DispLine;
import com.adobe.xfa.text.GlyphExtra;

class Glyph {
    private int mnGlyph;
    private float moOriginalX;
    private float moOriginalNextX;
    private boolean mbRTL;
    private boolean mbShifted;
    private boolean mbSpreadOffset;
    private boolean mbComb;
    private boolean mbInMultiple;
    private boolean mbAXTELigature;
    private boolean mbRenderByGlyphID;
    private int meGlyphOrientation = 0;
    private int mnExtraIndex = -1;

    Glyph() {
    }

    int getExtraIndex() {
        return this.mnExtraIndex;
    }

    void setExtraIndex(int nExtraIndex) {
        this.mnExtraIndex = nExtraIndex;
    }

    boolean hasExtra() {
        return this.mnExtraIndex >= 0;
    }

    GlyphExtra getExtra(DispLine poLine) {
        return this.hasExtra() ? poLine.getGlyphExtra(this.mnExtraIndex) : null;
    }

    int getGlyph() {
        return this.mnGlyph;
    }

    void setGlyph(int nGlyph) {
        this.mnGlyph = nGlyph;
    }

    boolean renderByGlyphID() {
        return this.mbRenderByGlyphID;
    }

    void setRenderByGlyphID(boolean bRenderByGlyphID) {
        this.mbRenderByGlyphID = bRenderByGlyphID;
    }

    float getDrawX(DispLine poLine) {
        return this.moOriginalX + this.getOffsetX(poLine);
    }

    float getDrawY(DispLine poLine) {
        return this.getOriginalY(poLine);
    }

    float getDrawNextX(DispLine poLine) {
        return this.moOriginalNextX + this.getOffsetX(poLine);
    }

    float getOriginalX() {
        return this.moOriginalX;
    }

    void setOriginalX(float oOriginalX) {
        this.moOriginalX = oOriginalX;
    }

    float getOriginalY(DispLine poLine) {
        return this.hasExtra() ? this.getExtra(poLine).getY() : 0.0f;
    }

    float getOriginalNextX() {
        return this.moOriginalNextX;
    }

    void setOriginalNextX(float oOriginalNextX) {
        this.moOriginalNextX = oOriginalNextX;
    }

    void shift(float oDelta) {
        this.moOriginalX += oDelta;
        this.moOriginalNextX += oDelta;
    }

    void setComb(DispLine poLine, float oDelta, float oOriginalNextX) {
        assert (this.hasExtra());
        GlyphExtra poExtra = poLine.getGlyphExtra(this.mnExtraIndex);
        this.mbComb = true;
        poExtra.setWidth(this.moOriginalNextX - this.moOriginalX);
        poExtra.setRTLWidth(poExtra.getWidth());
        poExtra.setOffsetX(poExtra.getOffsetX() + oDelta);
    }

    void setOrientation(int eGlyphOrientation) {
        this.meGlyphOrientation = eGlyphOrientation;
    }

    float getWidth(DispLine poLine) {
        return this.hasExtra() ? this.getExtra(poLine).getWidth() : this.moOriginalNextX - this.moOriginalX;
    }

    float getOffsetX(DispLine poLine) {
        return this.hasExtra() ? this.getExtra(poLine).getOffsetX() : 0.0f;
    }

    float getRTLWidth(DispLine poLine) {
        return this.hasExtra() ? this.getExtra(poLine).getRTLWidth() : 0.0f;
    }

    void setRTL(boolean bRTL) {
        this.mbRTL = bRTL;
    }

    boolean isRTL() {
        return this.mbRTL;
    }

    boolean isShifted() {
        return this.mbShifted;
    }

    void setShifted(boolean bShifted) {
        this.mbShifted = bShifted;
    }

    boolean isSpreadOffset() {
        return this.mbSpreadOffset;
    }

    void setSpreadOffset(boolean bSpreadOffset) {
        this.mbSpreadOffset = bSpreadOffset;
    }

    boolean isComb() {
        return this.mbComb;
    }

    boolean isInMultiple() {
        return this.mbInMultiple;
    }

    void setInMultiple(boolean bInMultiple) {
        this.mbInMultiple = bInMultiple;
    }

    boolean isAXTELigature() {
        return this.mbAXTELigature;
    }

    void setAXTELigature(boolean bAXTELigature) {
        this.mbAXTELigature = bAXTELigature;
    }

    int getGroup(DispLine poLine) {
        return this.hasExtra() ? this.getExtra(poLine).getGroup() : 0;
    }

    int getOrientation() {
        return this.meGlyphOrientation;
    }
}

