/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.handler;

import com.day.cq.contentsync.config.ConfigEntry;
import com.day.cq.contentsync.handler.HashableContentUpdateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDefaultContentUpdateHandler
extends HashableContentUpdateHandler {
    public static final String CONFIG_TARGET_PATH_PREFIX = "targetRootDirectory";
    private static final Logger log = LoggerFactory.getLogger(AbstractDefaultContentUpdateHandler.class);

    protected String getConfigCacheRoot(ConfigEntry configEntry, String configCacheRoot) {
        String prefixPath = configEntry.getValue(CONFIG_TARGET_PATH_PREFIX);
        if (prefixPath != null) {
            return configCacheRoot + "/" + prefixPath;
        }
        return configCacheRoot;
    }

    protected String getResolvedContentPath(ConfigEntry configEntry) {
        String configuredContentPath;
        String contentPath = configuredContentPath = configEntry.getContentPath();
        if (configuredContentPath.startsWith("..") || configuredContentPath.startsWith(".")) {
            contentPath = configEntry.getPath() + "/" + configuredContentPath;
            log.debug("Configured path '" + configuredContentPath + "' resolved to '" + contentPath + "'");
        }
        return contentPath;
    }
}

