/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import java.util.Iterator;

public class PrefixRenditionPicker
implements RenditionPicker {
    private String prefix;
    private boolean returnOriginal;

    public PrefixRenditionPicker(String startsWith) {
        this(startsWith, false);
    }

    public PrefixRenditionPicker(String prefix, boolean returnOriginal) {
        this.prefix = prefix;
        this.returnOriginal = returnOriginal;
    }

    @Override
    public Rendition getRendition(Asset asset) {
        Iterator<Rendition> renditions = asset.listRenditions();
        return this.getRendition(renditions);
    }

    public Rendition getRendition(Iterator<Rendition> renditions) {
        Rendition original = null;
        while (renditions.hasNext()) {
            Rendition rendition = renditions.next();
            if ("original".equals(rendition.getName())) {
                original = rendition;
            }
            if (!rendition.getName().startsWith(this.prefix)) continue;
            return rendition;
        }
        if (this.returnOriginal) {
            return original;
        }
        return null;
    }
}

