/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public class OakAnalyzer
extends Analyzer {
    private final Version matchVersion;
    private final int preserveOriginal;

    public OakAnalyzer(Version matchVersion) {
        this(matchVersion, false);
    }

    public OakAnalyzer(Version matchVersion, boolean indexOriginalTerm) {
        this.matchVersion = matchVersion;
        this.preserveOriginal = indexOriginalTerm ? 32 : 0;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer src = new StandardTokenizer(this.matchVersion, reader);
        TokenFilter tok = new LowerCaseFilter(this.matchVersion, src);
        tok = new WordDelimiterFilter(tok, 0x101 | this.preserveOriginal | 2, null);
        return new Analyzer.TokenStreamComponents(src, tok);
    }
}

