/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.ContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.FilteringIndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.UniqueEntryStoreStrategy;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public class Multiplexers {
    static boolean RO_PRIVATE_UNIQUE_INDEX;
    private static final IndexStoreStrategy UNIQUE;
    private static final IndexStoreStrategy MIRROR;

    private Multiplexers() {
    }

    public static Set<IndexStoreStrategy> getStrategies(boolean unique, MountInfoProvider mountInfoProvider, NodeBuilder definition, String defaultName) {
        Iterable<String> children = definition.getChildNodeNames();
        return Multiplexers.getStrategies(unique, mountInfoProvider, children, defaultName);
    }

    public static Set<IndexStoreStrategy> getStrategies(boolean unique, MountInfoProvider mountInfoProvider, NodeState definition, String defaultName) {
        Iterable<String> children = definition.getChildNodeNames();
        return Multiplexers.getStrategies(unique, mountInfoProvider, children, defaultName);
    }

    private static Set<IndexStoreStrategy> getStrategies(boolean unique, MountInfoProvider mountInfoProvider, Iterable<String> children, String defaultName) {
        if (mountInfoProvider.hasNonDefaultMounts()) {
            HashSet<String> names = new HashSet<String>();
            for (String string : children) {
                if (!Multiplexers.isIndexStorageNode(string, defaultName)) continue;
                names.add(string);
            }
            names.remove(defaultName);
            HashSet<IndexStoreStrategy> strategies = new HashSet<IndexStoreStrategy>();
            for (Mount m : mountInfoProvider.getNonDefaultMounts()) {
                String n = Multiplexers.getNodeForMount(m, defaultName);
                names.remove(n);
                strategies.add(Multiplexers.newStrategy(unique, false, n, m));
            }
            Mount mount = mountInfoProvider.getDefaultMount();
            for (String n : names) {
                strategies.add(Multiplexers.newStrategy(unique, true, n, mount));
            }
            strategies.add(Multiplexers.newStrategy(unique, true, defaultName, mount));
            return strategies;
        }
        return unique ? ImmutableSet.of((Object)Multiplexers.newUniqueStrategy(defaultName)) : ImmutableSet.of((Object)Multiplexers.newMirrorStrategy(defaultName));
    }

    private static IndexStoreStrategy newUniqueStrategy(String defaultName) {
        if (":index".equals(defaultName)) {
            return UNIQUE;
        }
        return new UniqueEntryStoreStrategy(defaultName);
    }

    private static IndexStoreStrategy newMirrorStrategy(String defaultName) {
        if (":index".equals(defaultName)) {
            return MIRROR;
        }
        return new ContentMirrorStoreStrategy(defaultName);
    }

    private static IndexStoreStrategy newStrategy(boolean unique, boolean defaultMount, String name, Mount m) {
        Predicate<String> filter = Multiplexers.newFilter(m);
        boolean readOnly = unique && !m.isDefault() && RO_PRIVATE_UNIQUE_INDEX;
        return unique ? new FilteringIndexStoreStrategy(new UniqueEntryStoreStrategy(name), filter, readOnly) : new FilteringIndexStoreStrategy(new ContentMirrorStoreStrategy(name), filter);
    }

    private static Predicate<String> newFilter(final Mount m) {
        return new Predicate<String>(){

            public boolean apply(String p) {
                return m.isMounted(p);
            }
        };
    }

    private static boolean isIndexStorageNode(String name, String defaultName) {
        return NodeStateUtils.isHidden(name) && (name.equals(defaultName) || name.endsWith(Multiplexers.asSuffix(defaultName)));
    }

    public static String getIndexNodeName(MountInfoProvider mountInfoProvider, String path, String defaultName) {
        Mount mount = mountInfoProvider.getMountByPath(path);
        return Multiplexers.getNodeForMount(mount, defaultName);
    }

    public static String getNodeForMount(Mount mount, String defaultName) {
        if (mount.isDefault()) {
            return defaultName;
        }
        return ":" + mount.getPathFragmentName() + Multiplexers.asSuffix(defaultName);
    }

    private static String asSuffix(String name) {
        return "-" + Multiplexers.stripStartingColon(name);
    }

    public static String stripStartingColon(String name) {
        if (name.startsWith(":")) {
            return name.substring(1);
        }
        return name;
    }

    static {
        String ro = System.getProperty("oak.multiplexing.readOnlyPrivateUniqueIndex", "false");
        RO_PRIVATE_UNIQUE_INDEX = Boolean.parseBoolean(ro);
        UNIQUE = new UniqueEntryStoreStrategy(":index");
        MIRROR = new ContentMirrorStoreStrategy(":index");
    }
}

