/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.math.BigDecimal;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.SinglePropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.jetbrains.annotations.NotNull;

public class DecimalPropertyState
extends SinglePropertyState<BigDecimal> {
    private final BigDecimal value;

    public DecimalPropertyState(@NotNull String name, @NotNull BigDecimal value) {
        super(name);
        this.value = (BigDecimal)Preconditions.checkNotNull((Object)value);
    }

    public static PropertyState decimalProperty(@NotNull String name, @NotNull BigDecimal value) {
        return new DecimalPropertyState(name, value);
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public Conversions.Converter getConverter() {
        return Conversions.convert(this.value);
    }

    @Override
    public Type<?> getType() {
        return Type.DECIMAL;
    }
}

