/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.guava.common.base.Charsets;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.apache.jackrabbit.oak.namepath.impl.GlobalNameMapper;
import org.apache.jackrabbit.oak.namepath.impl.NamePathMapperImpl;
import org.apache.jackrabbit.oak.plugins.name.ReadWriteNamespaceRegistry;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ReadWriteNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueFactoryImpl;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(NodeTypeRegistry.class);
    private static final boolean DEFAULT_REFERENCEABLE_FROZEN_NODE = false;
    private final NodeTypeManager ntMgr;
    private final NamespaceRegistry nsReg;
    private final ValueFactory vf;

    private NodeTypeRegistry(final Root root) {
        this.ntMgr = new ReadWriteNodeTypeManager(){

            @Override
            @NotNull
            protected Tree getTypes() {
                return root.getTree("/jcr:system/jcr:nodeTypes");
            }

            @Override
            @NotNull
            protected Root getWriteRoot() {
                return root;
            }
        };
        this.nsReg = new ReadWriteNamespaceRegistry(root){

            @Override
            protected Root getWriteRoot() {
                return root;
            }
        };
        this.vf = new ValueFactoryImpl(root, new NamePathMapperImpl(new GlobalNameMapper(root)));
    }

    public static void register(Root root, InputStream input, String systemId) {
        new NodeTypeRegistry(root).registerNodeTypes(input, systemId);
    }

    private void registerNodeTypes(InputStream stream, String systemId) {
        try {
            Reader reader = new InputStreamReader(stream, Charsets.UTF_8);
            boolean referenceableFrozenNode = (Boolean)SystemPropertySupplier.create((String)"oak.referenceableFrozenNode", (Object)false).loggingTo(LOG).formatSetMessage((name, value) -> String.format("oak.referenceableFrozenNode set to: %s (using system property %s)", name, value)).get();
            if (referenceableFrozenNode) {
                String line;
                BufferedReader bufferedReader = new BufferedReader(reader);
                StringBuilder result = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.trim().equals("[nt:frozenNode]")) {
                        line = "[nt:frozenNode] > mix:referenceable";
                    }
                    result.append(line).append(System.lineSeparator());
                }
                reader = new StringReader(result.toString());
            }
            CndImporter.registerNodeTypes(reader, systemId, this.ntMgr, this.nsReg, this.vf, false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read " + systemId, e);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Unable to parse " + systemId, e);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Unable to register " + systemId, e);
        }
    }
}

