/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.guava.common.base.Objects;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlList;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImmutableACL
extends AbstractAccessControlList {
    private final List<JackrabbitAccessControlEntry> entries;
    private final RestrictionProvider restrictionProvider;
    private int hashCode;

    public ImmutableACL(@Nullable String oakPath, @NotNull List<? extends JackrabbitAccessControlEntry> entries, @NotNull RestrictionProvider restrictionProvider, @NotNull NamePathMapper namePathMapper) {
        super(oakPath, namePathMapper);
        this.entries = ImmutableList.copyOf(entries);
        this.restrictionProvider = restrictionProvider;
    }

    public ImmutableACL(@NotNull AbstractAccessControlList accessControlList) {
        this(accessControlList.getOakPath(), accessControlList.getEntries(), accessControlList.getRestrictionProvider(), accessControlList.getNamePathMapper());
    }

    @Override
    public void removeAccessControlEntry(AccessControlEntry ace) throws AccessControlException {
        throw new AccessControlException("Immutable ACL. Use AccessControlManager#getApplicablePolicies in order to obtain an modifiable ACL.");
    }

    @Override
    public boolean addEntry(@NotNull Principal principal, @NotNull Privilege[] privileges, boolean isAllow, @Nullable Map<String, Value> restrictions) throws AccessControlException {
        throw new AccessControlException("Immutable ACL. Use AccessControlManager#getPolicy or #getApplicablePolicies in order to obtain an modifiable ACL.");
    }

    @Override
    public boolean addEntry(@NotNull Principal principal, @NotNull Privilege[] privileges, boolean isAllow, @Nullable Map<String, Value> restrictions, @Nullable Map<String, Value[]> mvRestrictions) throws AccessControlException {
        throw new AccessControlException("Immutable ACL. Use AccessControlManager#getPolicy or #getApplicablePolicies in order to obtain an modifiable ACL.");
    }

    @Override
    public void orderBefore(@NotNull AccessControlEntry srcEntry, @Nullable AccessControlEntry destEntry) throws AccessControlException {
        throw new AccessControlException("Immutable ACL. Use AccessControlManager#getPolicy or #getApplicablePolicy in order to obtain a modifiable ACL.");
    }

    @NotNull
    public List<JackrabbitAccessControlEntry> getEntries() {
        return this.entries;
    }

    @Override
    @NotNull
    public RestrictionProvider getRestrictionProvider() {
        return this.restrictionProvider;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hashCode((Object[])new Object[]{this.getOakPath(), this.entries});
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutableACL) {
            ImmutableACL other = (ImmutableACL)obj;
            return Objects.equal((Object)this.getOakPath(), (Object)other.getOakPath()) && this.entries.equals(other.entries);
        }
        return false;
    }
}

