/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.whiteboard;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.commons.jmx.JmxUtil;
import org.apache.jackrabbit.oak.spi.GuavaDeprecation;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhiteboardUtils {
    public static final String JMX_OAK_DOMAIN = "org.apache.jackrabbit.oak";

    public static Registration scheduleWithFixedDelay(Whiteboard whiteboard, Runnable runnable, long delayInSeconds) {
        return WhiteboardUtils.scheduleWithFixedDelay(whiteboard, runnable, delayInSeconds, false, false);
    }

    public static Registration scheduleWithFixedDelay(Whiteboard whiteboard, Runnable runnable, long delayInSeconds, boolean runOnSingleClusterNode, boolean useDedicatedPool) {
        return WhiteboardUtils.scheduleWithFixedDelay(whiteboard, runnable, Collections.emptyMap(), delayInSeconds, runOnSingleClusterNode, useDedicatedPool);
    }

    public static Registration scheduleWithFixedDelay(Whiteboard whiteboard, Runnable runnable, Map<String, Object> extraProps, long delayInSeconds, boolean runOnSingleClusterNode, boolean useDedicatedPool) {
        return WhiteboardUtils.scheduleWithFixedDelay(whiteboard, runnable, extraProps, delayInSeconds, runOnSingleClusterNode ? ScheduleExecutionInstanceTypes.RUN_ON_SINGLE : ScheduleExecutionInstanceTypes.DEFAULT, useDedicatedPool);
    }

    public static Registration scheduleWithFixedDelay(Whiteboard whiteboard, Runnable runnable, Map<String, Object> extraProps, long delayInSeconds, ScheduleExecutionInstanceTypes scheduleExecutionInstanceTypes, boolean useDedicatedPool) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(extraProps).put((Object)"scheduler.period", (Object)delayInSeconds).put((Object)"scheduler.concurrent", (Object)false);
        if (scheduleExecutionInstanceTypes == ScheduleExecutionInstanceTypes.RUN_ON_SINGLE) {
            builder.put((Object)"scheduler.runOn", (Object)"SINGLE");
        } else if (scheduleExecutionInstanceTypes == ScheduleExecutionInstanceTypes.RUN_ON_LEADER) {
            builder.put((Object)"scheduler.runOn", (Object)"LEADER");
        }
        if (useDedicatedPool) {
            builder.put((Object)"scheduler.threadPool", (Object)"oak");
        }
        return whiteboard.register(Runnable.class, runnable, (Map<?, ?>)builder.build());
    }

    public static <T> Registration registerMBean(Whiteboard whiteboard, Class<T> iface, T bean, String type, String name) {
        return WhiteboardUtils.registerMBean(whiteboard, iface, bean, type, name, Collections.emptyMap());
    }

    public static <T> Registration registerMBean(Whiteboard whiteboard, Class<T> iface, T bean, String type, String name, Map<String, String> attrs) {
        try {
            Hashtable<String, String> table = new Hashtable<String, String>(attrs);
            table.put("type", JmxUtil.quoteValueIfRequired(type));
            table.put("name", JmxUtil.quoteValueIfRequired(name));
            ImmutableMap.Builder properties = ImmutableMap.builder();
            properties.put((Object)"jmx.objectname", (Object)new ObjectName(JMX_OAK_DOMAIN, table));
            properties.putAll(attrs);
            return whiteboard.register(iface, bean, (Map<?, ?>)properties.build());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NotNull
    public static <T> List<T> getServices(@NotNull Whiteboard wb, @NotNull Class<T> type) {
        return WhiteboardUtils.getServices(wb, type, (Predicate)null);
    }

    @Nullable
    public static <T> T getService(@NotNull Whiteboard wb, @NotNull Class<T> type) {
        return WhiteboardUtils.getService(wb, type, (Predicate)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> List<T> getServices(@NotNull Whiteboard wb, @NotNull Class<T> type, @Nullable Predicate<T> predicate) {
        Tracker<T> tracker = wb.track(type);
        try {
            if (predicate == null) {
                List<T> list = tracker.getServices();
                return list;
            }
            ImmutableList immutableList = ImmutableList.copyOf((Iterable)Iterables.filter(tracker.getServices(), input -> predicate.test(input)));
            return immutableList;
        }
        finally {
            tracker.stop();
        }
    }

    @Deprecated(since="1.20.0", forRemoval=true)
    @NotNull
    public static <T> List<T> getServices(@NotNull Whiteboard wb, @NotNull Class<T> type, @Nullable com.google.common.base.Predicate<T> predicate) {
        GuavaDeprecation.handleCall((String)"OAK-8685");
        return WhiteboardUtils.getServices(wb, type, (T input) -> predicate.apply(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T getService(@NotNull Whiteboard wb, @NotNull Class<T> type, @Nullable Predicate<T> predicate) {
        Tracker<T> tracker = wb.track(type);
        try {
            for (T service : tracker.getServices()) {
                if (predicate != null && !predicate.test(service)) continue;
                T t = service;
                return t;
            }
            Iterator<T> iterator = null;
            return (T)iterator;
        }
        finally {
            tracker.stop();
        }
    }

    @Deprecated(since="1.20.0", forRemoval=true)
    @Nullable
    public static <T> T getService(@NotNull Whiteboard wb, @NotNull Class<T> type, @Nullable com.google.common.base.Predicate<T> predicate) {
        GuavaDeprecation.handleCall((String)"OAK-8685");
        return (T)WhiteboardUtils.getService(wb, type, (T input) -> predicate.apply(input));
    }

    public static enum ScheduleExecutionInstanceTypes {
        DEFAULT,
        RUN_ON_SINGLE,
        RUN_ON_LEADER;

    }
}

