/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.mcm.campaign;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

/**
 * Interface for creating the content of a newsletter.
 */
public interface ContentGenerator {

    /**
     * <p>Creates the HTML of the newsletter page.</p>
     *
     * <p>The HTML must use full URLs for images, links, etc.</p>
     *
     * <p>The provided response must not be used to do any output. Its provided for wrapping
     * purposes only!</p>
     *
     * @param request The originating request
     * @param response The original response - use for wrapping purposes only!
     * @return The HTML of the newsletter page
     * @throws NewsletterException if the HTML could not be created
     */
    String createHTML(SlingHttpServletRequest request, SlingHttpServletResponse response)
            throws NewsletterException;

}
