/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api.description;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;

/**
 * A description of an entity, or a child of the requested resource.
 */
@ProviderType
public interface EntityDescription {
    /**
     * Get the Resource.
     * @return The Resource.
     */
    @Nonnull
    Resource getResource();

    /**
     * Get the ModelDescription of model which describes the resource.
     * @return The ModelDescription.
     */
    @Nonnull
    ModelDescription getDescription();
}
