/* ****************************************************************************
 *
 *	File: TestUtil.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2003-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.util;




import java.io.IOException;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.types.ASName;

/**
 * Only for internal engineering use. This api can change without notice.
 */
public final class Utility
{
	private Utility(){}


	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public static boolean nameInArray(ASName key, ASName keys[])
	{
		int keyInd = 0;
		while (keyInd < keys.length) {
			if (key.equals(keys[keyInd++]))
				return true;
		}
		return false;
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Computes the new seach position for a comparison failure at each point in the
	 * search key.  The value of the next array is the amount of key that could still
	 * be matched if there is a failure at the given position.  It gives the index
	 * of an earlier part of the key that should be tested next.  For example, consider
	 * key = ABCABD.  If you fail on the 'D' at pattern position 5, you next test against
	 * pattern position 2, since the non-D character could have been a 'C'.  A value
	 * of -1 means the missed character cannot match the first in the pattern, so
	 * start looking at the beginning of the pattern, but at the next character in
	 * the target.
	 * @param key - array of bytes that may occur as a subset of target
	 * @returns - KMP failure array
	 *
	 */
	public static int[] ComputeKMPNextArray(byte[] key)
	{
		int pmax = key.length;
		int[] next = new int[pmax];
		for (int k = 0; k < pmax; k++) next[k] = -2; // for debugging
		int nextTest = -1;
		int i = 0;
		next[0] = -1; // if you fail on first char, always go to next in target
		do {
			if ((nextTest == -1) || (key[nextTest] == key[i])) {
				++i;
				++nextTest;
				if (i < pmax) {
					if (key[nextTest] == key[i]) {
						next[i] = next[nextTest];
					} else {
						next[i] = nextTest;
					}
				}
			} else {
				nextTest = next[nextTest];
			}
		} while (i < pmax);
		return next;
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Returns the offset in target of the first instance of key.  Uses the Knuth,
	 * Morris, Pratt linear search algorithm.  The "next" array give the position
	 * in the pattern to begin searching if there is a failure at the given point
	 * in the key.
	 * @param key - array of bytes that may occur as a subset of target
	 * @param next - KMP failure array
	 * @param target - array of bytes to be searched
	 * @return - index of first instance of key in target, -1 if no instance
	 */
	public static int KMPFindFirst(byte[] key, int[] next, byte[] target)
	{
		int keySize = key.length;
		int targetSize = target.length;
		int keyIndex = 0;
		int targetIndex = 0;
		while (targetIndex < targetSize) {
			if ((keyIndex == -1) || (key[keyIndex] == target[targetIndex])) {
				++keyIndex;
				if (keyIndex == keySize)
					return (targetIndex + 1) - keySize;
				++targetIndex;
			} else {
				keyIndex = next[keyIndex];
			}
		}
		return -1;
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Returns the offset in target of the first instance of key.  Uses the Knuth,
	 * Morris, Pratt linear search algorithm.  The "next" array give the position
	 * in the pattern to begin searching if there is a failure at the given point
	 * in the key.
	 * @param key - array of bytes that may occur as a subset of target
	 * @param next - KMP failure array
	 * @param targetstm - a ByteStream to be searched
	 * @return - index of first instance of key in targetstm, -1 if no instance
	 * @throws IOException
	 */
	public static long KMPFindFirst(byte[] key, int[] next, InputByteStream targetstm)
		throws IOException
	{
		int keySize = key.length;
		int keyIndex = 0;
		// FIXME_IO - check for EOF!
		byte targetbyte = (byte) targetstm.read();
		do {
			if ((keyIndex == -1) || (key[keyIndex] == targetbyte)) {
				++keyIndex;
				if (keyIndex == keySize)
					return (targetstm.getPosition() - keySize);
				if (targetstm.eof())
					return -1;
				// FIXME_IO - check for EOF!
				targetbyte = (byte) targetstm.read();
			} else {
				keyIndex = next[keyIndex];
			}
		} while (true);
	}
}
