/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa;


/**
 * Used by ScriptHandler to describe each script.
 * @exclude from public api.
 */
public class ScriptInfo {
	
	public ScriptInfo(String sScriptContents, String sLanguageName,
			Node oContextNode, String sRef, int eReason) {
		msScriptContents = sScriptContents;
		msLanguageName = sLanguageName;
		moContextNode = oContextNode;
		msRef = sRef;
		meReason = eReason;
	}

	public final String msLanguageName;   // eg formcalc or javascript
	public final String msScriptContents; // contents of script
	public final Node moContextNode; 	  // context node
	// String msContextNodeSOM; 		  // populated only in remote debugging contexts!
	public final String msRef; 			  // ref tag if applicable, eg "$" or "$layout". May be empty string if not applicable (i.e. if ref tag not supported in context).
	public final int meReason; 			  // eg CALCULATE or ACTIVITY_READY
}
