/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.Obj;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.STRS;
import com.adobe.xfa.Element;


/**
 * @exclude from public api.
 */
public class FormDependencyTracker extends DependencyTracker {
	
	private final AppModel	mAppModel;
	private final FormModel	mFormModel;
	private final Element	mNode;
	private final boolean	mbIsCalculate;	// true if calculate script, false if validate script
	
	public FormDependencyTracker(Element node, boolean bIsCalculate) {
		
		assert( node instanceof FormField ||
			    node instanceof FormSubform ||
				node instanceof FormExclGroup);
		
		mNode = node;
		mbIsCalculate = bIsCalculate;		
		
		// note would be nice to directly access mpoNodeImpl.mpModel
		mFormModel = (FormModel)mNode.getModel();
		mAppModel = mFormModel.getAppModel();
		mAppModel.dependencyTracker(this);
	}

	void dispose() {
		mAppModel.dependencyTracker(null);
	}

	// overridden from XFADependencyTracker
	public void addDependency(Obj dependsOn) {
		// vantive 666665: calculate should never have a dependency on itself... otherwise 
		// you always go into a loop where calculate changes it own value so it fires the calculate again...
		if (mNode == dependsOn && mbIsCalculate)
			return;

		mFormModel.addScriptDependency(mNode, dependsOn, mbIsCalculate);
	}

	public void addVirtualDependency(Obj context, String sPropertyName) {
		// for subforms and subformsets add the dependency on any nameless 
		// instance manager or one with the same name as sPropertyName
		if (context.isSameClass(XFA.SUBFORMSET) || 
			context.isSameClass(XFA.SUBFORM) ) {	
			Element node = (Element)context;
			// if not a form node we don't care
			if (node.getModel() != mFormModel )
				return;

			String sNodeName = "_" + sPropertyName;
			String aNodeName = sNodeName.intern();
			
			for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
				if (child.isSameClass(XFA.INSTANCEMANAGERTAG) &&
					(child.getName() == STRS.UNDERSCORE ||
					 child.getName() == aNodeName)) {
	    			addDependency(child);
				}
			}
		}
	}
}
