/*
 * Adobe Confidential
 * ------------------
 * Copyright 2005 Adobe Systems Incorporated.  All Rights Reserved.
 *
 * Notice: all information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any.  The intellectual and 
 * technical concepts contained herein are proprietary to Adobe Systems Inc.
 * and its suppliers and may be covered by U.S. and foreign patents, patents in 
 * process, and are protected by trade secret or copyright law.  Dissemination 
 * of this information or reproduction of this material is strictly forbidden 
 * unless prior written permission is obtained from Adobe Systems Incorporated.
 */
 package com.adobe.xfa.svg;

 import com.adobe.xfa.XFA;

/**
 * This is the SVG class.  It is modelled after the XFA class. Here is
 * where we control all the keywords supported in our subset of SVG.
 *
 * @exclude from published api.
 */
public final class SVG {

	// ELEMENTS
	public static final String TEXTDATA = "#text";
	public static final String DESC = "desc";
	public static final String G = "g";
	public static final String LINE = "line";
	public static final String SVG = "svg";
	public static final String TEXT = "text";
	public static final String TSPAN = "tspan";

	// ATTRIBUTES
	public static final String ALTGLYPH = "altGlyph";
	public static final String CODEPAGE = "codepage";
	public static final String FILL = "fill";
	public static final String FONTFAMILY = "font-family";
	public static final String FONTSIZE = "font-size";
	public static final String FONTSTYLE = "font-style";
	public static final String FONTWEIGHT = "font-weight";
	public static final String HEIGHT = "height";
	public static final String ID = "id";
	public static final String STROKE = "stroke";
	public static final String STROKEWIDTH = "stroke-width";
	public static final String TRANSFORM = "transform";
	public static final String VIEWBOX = "viewBox";
	public static final String WIDTH = "width";
	public static final String X = "x";
	public static final String X1 = "x1";
	public static final String X2 = "x2";
	public static final String XMLNS = "xmlns";
	public static final String Y = "y";
	public static final String Y1 = "y1";
	public static final String Y2 = "y2";

	// TAG ENUM FOR ALL SVG NAMESPACED STRINGS
	public static final int SVG_INVALID = -1;
	public static final int SVG_ELEMENT_MIN  = XFA.SVG_START;

	// ELEMENTS
	public static final int TEXTDATATAG = SVG_ELEMENT_MIN;
	public static final int DESCTAG = TEXTDATATAG +1;
	public static final int GTAG = DESCTAG +1;
	public static final int LINETAG = GTAG +1;
	public static final int SVGTAG = LINETAG +1;
	public static final int TEXTTAG = SVGTAG +1;
	public static final int TSPANTAG = TEXTTAG +1;

	public static final int SVG_ELEMENT_MAX = TSPANTAG;
	public static final int SVG_ELEMENT_COUNT = SVG_ELEMENT_MAX - SVG_ELEMENT_MIN + 1;
	public static final int SVG_ATTRIBUTE_MIN = SVG_ELEMENT_MAX + 1;

	// ATTRIBUTES
	public static final int ALTGLYPHTAG = SVG_ATTRIBUTE_MIN;
	public static final int CODEPAGETAG = ALTGLYPHTAG +1;
	public static final int FILLTAG = CODEPAGETAG +1;
	public static final int FONTFAMILYTAG = FILLTAG +1;
	public static final int FONTSIZETAG = FONTFAMILYTAG +1;
	public static final int FONTSTYLETAG = FONTSIZETAG +1;
	public static final int FONTWEIGHTTAG = FONTSTYLETAG +1;
	public static final int HEIGHTTAG = FONTWEIGHTTAG +1;
	public static final int IDTAG = HEIGHTTAG +1;
	public static final int STROKETAG = IDTAG +1;
	public static final int STROKEWIDTHTAG = STROKETAG +1;
	public static final int TRANSFORMTAG = STROKEWIDTHTAG +1;
	public static final int VIEWBOXTAG = TRANSFORMTAG +1;
	public static final int WIDTHTAG = VIEWBOXTAG +1;
	public static final int XTAG = WIDTHTAG +1;
	public static final int X1TAG = XTAG +1;
	public static final int X2TAG = X1TAG +1;
	public static final int XMLNSTAG = X2TAG +1;
	public static final int YTAG = XMLNSTAG +1;
	public static final int Y1TAG = YTAG +1;
	public static final int Y2TAG = Y1TAG +1;

	public static final int SVG_ATTRIBUTE_MAX = Y2TAG;
	public static final int SVG_ATTRIBUTE_COUNT  = SVG_ATTRIBUTE_MAX - SVG_ATTRIBUTE_MIN + 1;
	public static final int SVG_KEYWORD_COUNT = SVG_ATTRIBUTE_MAX - SVG_ELEMENT_MIN + 1;


	// MISC
	public static final String XFACAPTION = "Caption";
	public static final String XFACONTENT = "Content";


	/**
	 * Find a tag in SVG namespace by name.
     *
     * @param aSVGName the input name to search for.
     * @return the eTag value if found and SVG_INVALID if not.
     */
	static public int getTag(String aSVGName) {
		int eRet = SVGSchema.getTagImpl(aSVGName, true);
		if (eRet != -1)
			return eRet;
		return SVGSchema.getTagImpl(aSVGName, false);
	}

	/**
	 * Find an element tag in SVG namespace by name.
     *
     * @param aSVGName the input name to search for.
     * @return the eTag value of the element if found and SVG_INVALID if not.
     */
	static public int getElementTag(String aSVGName) {
		return SVGSchema.getTagImpl(aSVGName, true);
	}

	/**
	 * Find an attribute tag in SVG namespace by name.
     *
     * @param aSVGName the input name to search for.
     * @return the eTag value of the attribute if found and SVG_INVALID if not.
     */
	static public int getAttributeTag(String aSVGName) {
		return SVGSchema.getTagImpl(aSVGName, false);
	}

	// return a string base on a tag
	static public String getString(int eTag) {
		return SVGSchema.getSVGSchema().getAtom(eTag);
	}

	// return an atom based on a tag
	static public String getAtom(int eTag) {
		return SVGSchema.getSVGSchema().getAtom(eTag);
	}

}
