/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.ui;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;


/**
 * This class implements the functionality represented by the <ui> element in
 * the XFA grammar.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public final class UI extends ProtoableNode {

	public UI(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.UI, XFA.UI, null, XFA.UITAG, XFA.UI);
	}

	/**
	 * Get the UI element for this UI node. There may be more one UI element.
	 * This method will return the most appropriate UI based on the context of
	 * the call.
	 * 
	 * @param bPeek -
	 *            If true and if no UI elements are present then an XFADefaultUI
	 *            will be returned. Should NOT modify returned node if true.
	 * 
	 * @return an Node of the UIElement.
	 */
	public Element getUIElement(boolean bPeek/* = false */) {
		return (Element) getOneOfChild(bPeek, false);
	}

	public  int defaultElement() {
		// get the value
		Element pValueNode = getXFAParent().getElement(XFA.VALUETAG,0);

		// if value exists, return the appropriate ui element
		if (pValueNode != null) {
			Node pContentNode = pValueNode.getOneOfChild();

			if (pContentNode != null) {

				if (pContentNode.isSameClass(XFA.DATETIMETAG)
						|| pContentNode.isSameClass(XFA.DATETAG)
						|| pContentNode.isSameClass(XFA.TIMETAG))
					return XFA.DATETIMEEDITTAG;

				if (pContentNode.isSameClass(XFA.DECIMALTAG)
						|| pContentNode.isSameClass(XFA.FLOATTAG)
						|| pContentNode.isSameClass(XFA.INTEGERTAG))
					return XFA.NUMERICEDITTAG;

				if (pContentNode.isSameClass(XFA.BOOLEANTAG))
					return XFA.CHECKBUTTONTAG;
				
				if (pContentNode.isSameClass(XFA.TEXTTAG))
					return XFA.TEXTEDITTAG;

				if (pContentNode.isSameClass(XFA.IMAGETAG))
					return XFA.IMAGEEDITTAG;
			}
		}

		// default
		return XFA.DEFAULTUITAG;
	}

}
