// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2012 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.core.serializer;

import java.util.HashMap;
import java.util.Map;


/**
 * The context object for the RDFXMLSerializer.
 * It provides the serialization options to the RDF/XML serializer implementation.
 */
@SuppressWarnings("serial")
public class RDFXMLSerializerContext extends HashMap<String, Object>
{
	/** The context key for the serialization options */
	public static final String SERIALIZE_OPTIONS = "serializeOptions";
	/** An optional prefix-to-namespace contract for custom serialization */
	public static final String PREFIX_CONTRACT = "prefixContract";

	
	/**
	 * Default constructor
	 */
	public RDFXMLSerializerContext()
	{
		super();
	}
	
	
	/**
	 * Constructor for a context with serialization options.
	 * 
	 * @param options serialization options
	 */
	public RDFXMLSerializerContext(SerializeOptions options)
	{
		super.put(SERIALIZE_OPTIONS, options);
	}
	
	
	/**
	 * Constructor for a context with serialization options and the prefix contract.
	 * 
	 * @param options serialization options
	 * @param prefixContract prefix to namespace-map that contains proposed prefixes for the output
	 */
	public RDFXMLSerializerContext(SerializeOptions options, Map<String, String> prefixContract)
	{
		this(options);
		super.put(PREFIX_CONTRACT, prefixContract);
	}
	
}
