package com.day.cq.dam.commons.metadata;

import java.io.IOException;
import java.io.InputStream;

/**
 * Filtering XMP metadata.
 */
public interface XmpFilter {

    /**
     * Filter XMP properties from an XML inputstream and return the filtered XML in a new inputstream.
     *
     * @param xmpIS the XML for filtering
     * @return the filtered XML in utf-8 encoding
     */
    InputStream filter(InputStream xmpIS) throws IOException;

    boolean isActive();

    /**
     * Sieve XMP properties from an XML inputstream and return the properties hold back during filtering
     * in a new XMP document. Sieving is the opposite of filtering in regard to XMP XMP elements with
     * one exception: sieve will never return partial properties.
     *
     * This means, {@link #filter(InputStream)} may return the partial contents of an array XMP property (e.g.
     * the first 10 entries). {@link #sieve(InputStream)} will either report the complete array or
     * ignore the property.
     *
     * Example: during ingestion, all but the first entry in xmpMM:History is filtered. The reported
     * metadata contains just this one entry. If this metadata was written back to the document, all
     * existing subsequent xmpMM:History entries would be overwritten and lost.
     *
     * The {@link #sieve(InputStream)}, called on the original data, will return such a property in full,
     * e.g. the complete xmpMM:History. This allows the caller to merge changes as it desires.
     *
     * @param xmpIS the XML for sieving
     * @return the filtered XML in utf-8 encoding
     */
    InputStream sieve(InputStream xmpIS) throws IOException;
}
