/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.model;

import java.util.Map;

/**
 * Abstraction of a Scene7 Property Set.
 */
public interface Scene7PropertySet {

    /**
     * Returns this property set's set handle.
     * 
     * @return a {@code String} with the set handle
     */
    String getSetHandle();

    /**
     * Returns this property set's type handle.
     * 
     * @return a {@code String} with the type handle
     */
    String getTypeHandle();
    
    /**
     * Returns this property set's properties.
     * @return a {@code Map} with the properties; can be empty for property sets without properties
     */
    Map<String, String> getProperties();
}
