package com.day.cq.rewriter.pipeline;

import com.day.cq.rewriter.linkchecker.LinkCheckerSettings;
import org.xml.sax.Attributes;

/**
 * The <code>OptingRequestRewriter</code> interface defines an optional service which is used to rewrite
 * attributes and links. It extends {@link RequestRewriter}. Multiple implementations of this interface
 * may be provided. Highest ranked OptingRequestRewriter whose
 * {@link #accepts(String, Attributes, LinkCheckerSettings)} returns true will be used for rewriting unless
 * there is a RequestRewriter service available. If a RequestRewriter implementation is available,
 * OptingRequestRewriter will not be checked/used, the RequestRewriter will be used for rewriting.
 */
public interface OptingRequestRewriter extends RequestRewriter {

    /**
     * Returns true if this rewriter can rewrite attributes or links in the given element
     * @param elementName the element name
     * @param attributes the attributes of the element
     * @param settings The settings
     * @return true if link/attributes can be rewritten by this instance
     */
    boolean accepts(final String elementName,
                    final Attributes attributes,
                    final LinkCheckerSettings settings);

}
