/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api.components;

import java.util.Collection;

import org.apache.sling.api.resource.Resource;

/**
 * Provides access to CQ5 Components.
 * Note: Since 5.4 the component access is sped up by bypassing access checks
 * on the user component level. i.e. the components returned by this
 * manage might not be visible to the underlying resource resolver. Consumers of
 * this manager should call {@link Component#isAccessible()} prior of using it.
 */
public interface ComponentManager {

    /**
     * Returns the component according to the type of the resource or
     * <code>null</code> if no such component exists.
     *
     * @param resource to resolve
     * @return the respective component or <code>null</code>
     */
    Component getComponentOfResource(Resource resource);

    /**
     * Returns the component at the given path. The path can be relative.
     * @param path component path
     * @return the component or <code>null</code>
     */
    Component getComponent(String path);

    /**
     * Returns all components configured in the system.
     *
     * @return all components.
     */
    Collection<Component> getComponents();
}