/*
 * File: GujaratiFormatter.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;

public class GujaratiFormatter extends IndicFormatter {

  protected int splitVowelsAndNormalize (AttributedRun run, int start, int limit) {
    return limit;
  }

  protected int nukta () {
    return 0x0ABC;
  }

  protected int virama () {
    return 0xACD;
  }

  protected boolean isConsonant (int usv) {
    return (   0xA95 <= usv && usv <= 0xAB9
            || 0xAE0 <= usv && usv <= 0xAE1
            || 0x9F0 <= usv && usv <= 0x9F0
            || 0x25cc == usv);
  }

  protected boolean hasNukta (int usv) {
    return false;
  }

  protected int removeNukta (int usv) {
    return usv;
  }

  protected boolean isMark (int usv) {
    return (   0x0ABE <= usv && usv <= 0x0ACC
            || 0x0AE2 <= usv && usv <= 0xAE3 
            || 0x0A81 <= usv && usv <= 0xA83);
  }

  protected boolean isIndependentVowel (int usv) {
    return (   0x0A85 <= usv && usv <= 0x0A94
            || 0x0AE0 <= usv && usv <= 0x0AE1
            || 0x25cc == usv);
  }

  protected Position getPosition (int usv) {
    switch (usv) {
      case 0xABF: return Position.left;
      
      case 0xAC5:
      case 0xAC7:
      case 0xAC8: return Position.topMatra;
      
      case 0xA81:
      case 0xA82: return Position.topOther;
      
      case 0xAC1:
      case 0xAC2:
      case 0xAC3:
      case 0xAC4:
      case 0xAE2:
      case 0xAE3: return Position.bottom;
          
      case 0xABE:
      case 0xAC0:
      case 0xAC9:
      case 0xACB:
      case 0xACC: return Position.rightMatra;
      
      case 0xA83: return Position.rightOther;
      
      default:    return Position.any; }
  }
  
  protected Shape rephLike (int usv) {
    if (0xAB0 == usv) {
      return Shape.rephCons; }
    else {
      return Shape.any; }
  }

  protected boolean subjoins (int usv) {
    return (usv == 0xAB0);
  }
  
  protected boolean postjoins (int usv) {
    return false;
  }
  
  protected boolean postjoinsIndependentVowels (int usv) {
    return false;
  }
}