/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2019 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget;

import java.util.Optional;
import java.util.StringJoiner;

/**
 * A {@link Exception} extension that is used to provide formatted exception messages for use in the UI.
 */
public abstract class TestandtargetFormattedException extends Exception {

    public static final String LINE_SEPARATOR = System.lineSeparator();

    public TestandtargetFormattedException() {

    }

    public TestandtargetFormattedException(String message) {
        super(message);
    }

    public TestandtargetFormattedException(String message, Throwable cause) {
        super(message, cause);
    }

    public TestandtargetFormattedException(Throwable throwable) {
        super(throwable);
    }

    /**
     * Concatenates message from constructor with the nested's throwable message. Lines are separated by {@link TestandtargetFormattedException#LINE_SEPARATOR}
     *
     * @return exception message
     */
    public String getFormattedMessage() {
        StringJoiner output = new StringJoiner(LINE_SEPARATOR);

        // add message from constructor if available
        Optional.ofNullable(super.getMessage())
                .ifPresent(output::add);


        // add nested throwable's message from constructor if available
        // TestandtargetFormattedException provides a formatted message. Using this if available.
        Throwable cause = getCause();
        if (cause instanceof TestandtargetFormattedException) {
            Optional.ofNullable(cause)
                    .map(TestandtargetFormattedException.class::cast)
                    .map(TestandtargetFormattedException::getFormattedMessage)
                    .ifPresent(output::add);
        }
        else {
            Optional.ofNullable(cause)
                    .map(Throwable::getMessage)
                    .ifPresent(output::add);
        }

        return output.toString();
    }
}
