/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

/**
 * This interface defines the sorting of a column.
 */
public interface Sorting {

    /**
     * Defines available sorting directions.
     */
    public static enum Direction {

        /**
         * Sort ascending
         */
        ASCENDING("ASC"),

        /**
         * Sort descending
         */
        DESCENDING("DESC");

        /**
         * String representation of the direction
         */
        private final String strRep;

        /**
         * Private constructor for creating a new sorting direction.
         *
         * @param strRep The string representation
         */
        private Direction(String strRep) {
            this.strRep = strRep;
        }

        /**
         * Gets the string representation of the direction.
         *
         * @return The string representation ("ASC", "DESC")
         */
        public String getStringRepresentation() {
            return this.strRep;
        }

        /**
         * <p>Returns the corresponding <code>Direction</code> value for the specified
         * string representation.</p>
         *
         * @param strRep The string representation
         * @return The corresponding <code>Direction</code> value; <code>null</code> if an
         *         invalid string representation was provided
         */
        public static Direction fromStringRepresentation(String strRep) {
            Direction[] directions = values();
            for (Direction toCheck : directions) {
                if (toCheck.getStringRepresentation().equals(strRep)) {
                    return toCheck;
                }
            }
            return null;
        }

    }

    /**
     * Returns if the column is currently sorted.
     *
     * @return <code>true</code> if the column is currently sorted
     */
    boolean isSorted();

    /**
     * Returns the sorting direction if the column is currently sorted.
     *
     * @return The sorting direction; <code>null</code> if the column is currently unsorted
     */
    Direction getDirection();

}
