/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.core.stats;

import com.day.crx.statistics.PathBuilder;
import com.day.crx.statistics.Entry;

/**
 * <code>PageViewPathBuilder</code> implements a {@link PathBuilder} for
 * {@link PageView} instances.
 * 
 * @author asaar
 */
public class PageViewPathBuilder extends PathBuilder {
    /** The name of the node that contains the statistical data about a page */
    public static final String STATS_NAME = ".stats";

    /** The path of the page. */
    private final String path;

    /** 
     * Default constructor 
     * @param path The given path.
     * */
    public PageViewPathBuilder(String path) {
        super("yyyy/MM/dd");
        this.path = path;
    }

    /**
     * Formats the path for a {@link PageView} instance.
     * 
     * @param entry
     *            a {@link PageView} instance
     * @param buffer
     *            where to write the path to
     */
    public void formatPath(Entry entry, StringBuffer buffer) {
        PageView pv = (PageView) entry;
        buffer.append(pv.getPathPrefix());
        buffer.append(path);
        buffer.append("/").append(STATS_NAME).append("/");

        // add date nodes as specified in constructor pattern
        super.formatPath(pv, buffer);
    }
}
