/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.msm.api;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;
import com.day.cq.commons.JSONItem;

@ProviderType
public interface LiveStatus extends JSONItem {
    /**
     * Returns true if relationship is cancelled
     * @return true if relationship is cancelled
     */
    public boolean isCancelled();

    /**
     * Returns true if relationship is cancelled for children relationships. Only possible if isCancelled() is true.
     * @return true if relationship is cancelled for children relationships
     */
    public boolean isCancelledForChildren();

    /**
     * Returns true if relationship can be edited, ie can be cancelled.
     * @return true if relationship can be edited
     */
    public boolean isEditable();

    /**
     * Returns true if relationship's source exists
     * @return true if relationship's source exists
     */
    public boolean isSourceExisting();

    /**
     * Returns true if relationship's target exists
     * @return true if relationship's target exists
     */
    public boolean isTargetExisting();

    /**
     * Returns a map of pairs (name, status) which contains advanced status for the current relationship.
     * @return map of status
     */
    public Map<String,Boolean> getAdvancedStatus();

    /**
     * Returns value of an advanced status.
     * @param status the name of the status to be accessed
     * @return value of advanced status
     */
    public Boolean getAdvancedStatus(String status);

    /**
     * Returns true if relationship concerns a page, false if it concerns
     * a paragraph
     * @return true if relationship concerns a page
     */
    public boolean isPage();
    
    /**
     * Returns names of properties for which inheritance is canceled.
     * @return value of advanced status
     */
    public List<String> getCanceledProperties();

    /**
     * Return an identifier for the User that triggered the last Roll-out on the LiveRelationship this is the LiveStatus for.
     * The identifier matches the one of the ResourceResolver used
     * (s. {@link org.apache.sling.api.resource.ResourceResolver#getUserID()}).<br>
     * The returned value can be <code>null</code>.
     * Such cases could be. A LiveRelationship that has never been rolled out, has a no LiveStatus for the User
     *
     * @return an identifier of the subject that triggered the last Roll-out.
     * @see org.apache.sling.api.resource.ResourceResolver#getUserID()
     * @see com.day.cq.wcm.msm.api.RolloutManager#rollout(com.day.cq.wcm.msm.api.RolloutManager.RolloutParams)
     * @since 5.8.0
     */
    public String getLastRolledOutBy();

    /**
     * Return the timestamp of the last roll-out on the LiveRelationship this is the LiveStatus for.
     * It is not necessary that the Resource changed at that time.
     * The returned value can be <code>null</code> in case of a LiveStatus for a LiveRelationship that has never
     * been rolled-out.
     *
     * @return Calendar of the time the LiveRelationship this LiveStatus is for was roll-ed out
     * @see com.day.cq.wcm.msm.api.RolloutManager#rollout(com.day.cq.wcm.msm.api.RolloutManager.RolloutParams)
     * @since 5.8.0
     */
    public Date getLastRolledOut();
}
