/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.timeout.autoadvance;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Route;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.job.AbsoluteTimeoutHandler;
import com.day.cq.workflow.metadata.MetaDataMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * <code>AutoAdvancer</code>...
 *
 */
@Component(metatype = false)
@Service(value={WorkflowProcess.class, AbsoluteTimeoutHandler.class})
@Properties({
        @Property(name="service.description", value="Workflow Auto Advance Process"),
        @Property(name="process.label", value = "Absolute Time Auto Advancer")
})
public class AbsoluteTimeAutoAdvancer extends AutoAdvancer implements AbsoluteTimeoutHandler {          // TODO test
	/** Default log. */
	protected final Logger log = LoggerFactory.getLogger(AbsoluteTimeAutoAdvancer.class);

    public void execute(WorkItem item, WorkflowSession session, MetaDataMap args) throws WorkflowException {
		try {
			boolean advanced = false;
			List<Route> routes = session.getRoutes(item);
			for (Route route : routes) {
				if (route.hasDefault()) {
					String fromTitle = item.getNode().getTitle();
					String toTitle = route.getDestinations().get(0).getTo()
							.getTitle();
                    session.complete(item, route);
					log.debug(item.getId() + " advanced from " + fromTitle
							+ " to " + toTitle);
					advanced = true;
				}
			}
			// fallback if no route was marked as default
			if (!advanced) {
				session.complete(item, routes.get(0));

				String fromTitle = item.getNode().getTitle();
				String toTitle = routes.get(0).getDestinations().get(0).getTo()
						.getTitle();
				log.debug(item.getId() + " advanced from " + fromTitle + " to "
						+ toTitle);
			}
		} catch (WorkflowException e) {
			log.error("Could not advance workflow.", e);
		}
	}


    public long getTimeoutDate(WorkItem workItem) {
        Long date = workItem.getWorkflowData().getMetaDataMap().get(AbsoluteTimeoutHandler.ABS_TIME, Long.class);
        return date != null ? date : -1;
    }
}
