/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.text.DispChange;
import com.adobe.xfa.text.DispLineRaw;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.DispMapSet;
import com.adobe.xfa.text.DispTab;
import com.adobe.xfa.text.DrawParm;
import com.adobe.xfa.text.FormatInfo;
import com.adobe.xfa.text.FrameCaretRect;
import com.adobe.xfa.text.FrameCaretStartEnd;
import com.adobe.xfa.text.FrameDispInfo;
import com.adobe.xfa.text.FrameGfxDraw;
import com.adobe.xfa.text.LocaleInfo;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextBreakFinder;
import com.adobe.xfa.text.TextContext;
import com.adobe.xfa.text.TextDrawInfo;
import com.adobe.xfa.text.TextField;
import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextSparseStream;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.UnitSpan;

public class TextDisplay {
    TextSparseStream mpoStream;
    public GFXEnv mpoEnv;
    public int mnLineCount;
    public int mnSuppressFormat;
    public int mnIgnoreUpdates;
    public final DispChange moChange = new DispChange();
    public final Storage<DispTab> moTabs = new Storage();
    public LocaleInfo moLocaleInfo;
    public TextBreakFinder mpoBreakFinder;
    public int meLayoutOrientation = 0;
    public boolean mbHasFontSubstitution;

    public boolean gfxDraw(TextDrawInfo oDrawInfo) {
        Rect oTranslated = oDrawInfo.getInvalid();
        if (oTranslated == null || oTranslated.isDegenerate()) {
            oTranslated = TextDisplay.computeClipRect(this.mpoStream, oDrawInfo.getInvalidDefault());
        }
        DrawParm oParm = new DrawParm(oDrawInfo);
        oParm.setInvalid(oTranslated);
        if (oDrawInfo.getTruncate()) {
            Rect oExtent = TextDisplay.computeClipRect(this.mpoStream);
            oParm.setTruncate(oExtent);
        }
        FrameGfxDraw oDraw = new FrameGfxDraw(this.mpoStream, oParm);
        oDraw.processFrames();
        return oDraw.fits();
    }

    public int lines() {
        return this.mnLineCount;
    }

    public boolean suppressFormat() {
        return this.mnSuppressFormat > 0;
    }

    public void pushSuppressFormat() {
        ++this.mnSuppressFormat;
    }

    public void popSuppressFormat() {
        if (this.mnSuppressFormat > 0) {
            if (this.mnSuppressFormat > 1) {
                --this.mnSuppressFormat;
            } else {
                this.clearSuppressFormat();
            }
        }
    }

    public void clearSuppressFormat() {
        if (this.mnSuppressFormat == 0) {
            return;
        }
        this.mnSuppressFormat = 0;
        this.layout(true);
    }

    public boolean hasFontSubstitution() {
        return this.mbHasFontSubstitution;
    }

    public void setFontSubstitution(boolean bSubstitution) {
        this.mbHasFontSubstitution = bSubstitution;
    }

    public void updateSuspectLayout() {
        boolean bUpdated = false;
        for (int i = 0; i < this.mpoStream.getFrameCount(); ++i) {
            int nEndIndex;
            TextFrame poFrame = this.mpoStream.getFrame(i);
            if (poFrame == null || poFrame.getLayoutState() != 2) continue;
            int nStartIndex = poFrame.getStart().index();
            int nNextFrame = i + 1;
            if (nNextFrame >= this.mpoStream.getFrameCount()) {
                nEndIndex = this.mpoStream.posnCount();
            } else {
                DispLineWrapped poLast;
                TextFrame poNextFrame = this.mpoStream.getFrame(nNextFrame, true);
                TextPosnBase oEndPosn = new TextPosnBase(poNextFrame.getStart());
                int nLines = poFrame.getLineCount();
                if (nLines > 0 && (poLast = poFrame.getLine(nLines - 1)).getLastParaLine() >= 2) {
                    oEndPosn.prevUserPosn();
                }
                nEndIndex = oEndPosn.index();
            }
            this.moChange.frame(this.mpoStream, nStartIndex, nEndIndex - nStartIndex);
            this.layout(true, i, true, null);
            bUpdated = true;
        }
        if (bUpdated) {
            // empty if block
        }
    }

    public TextSparseStream stream() {
        return this.mpoStream;
    }

    Rect runtimeExtent(boolean bExtended) {
        FrameDispInfo oInfoFinder = new FrameDispInfo(this.mpoStream, bExtended);
        oInfoFinder.processFrames();
        return oInfoFinder.getExtent();
    }

    public Rect runtimeExtent() {
        return this.runtimeExtent(false);
    }

    Rect frame0Extent() {
        if (this.mpoStream == null) {
            return null;
        }
        TextFrame poFrame = this.mpoStream.forceFrame(0);
        if (poFrame == null) {
            return null;
        }
        return poFrame.getExtent();
    }

    void recomputeLineCount() {
        this.mnLineCount = 0;
        int nFrames = this.mpoStream.getFrameCount();
        for (int i = 0; i < nFrames; ++i) {
            TextFrame poFrame = this.mpoStream.getFrame(i);
            if (poFrame == null) continue;
            this.mnLineCount += poFrame.getLineCount();
        }
    }

    void connectStream(TextSparseStream poNewStream, boolean bSuppressLayout, TextAttr poDefaultAttr) {
        this.cleanup();
        this.mpoStream = poNewStream;
        this.mpoStream.textDisplaySet(this);
        if (!bSuppressLayout) {
            this.create(poDefaultAttr);
        }
    }

    void connectStream(TextSparseStream poNewStream, boolean bSuppressLayout) {
        this.connectStream(poNewStream, false, null);
    }

    void connectStream(TextSparseStream poNewStream) {
        this.connectStream(poNewStream, false);
    }

    void create(TextAttr poDefaultAttr) {
        this.moChange.full();
        this.layout(false, 0, false, poDefaultAttr);
    }

    boolean update() {
        if (this.mnIgnoreUpdates > 0) {
            return true;
        }
        this.moChange.full();
        return this.layout(true);
    }

    boolean updateInsert(TextStream poStream, int nIndex, int nChange) {
        if (this.mnIgnoreUpdates > 0) {
            return true;
        }
        this.moChange.insert(poStream, nIndex, nChange);
        return this.layout(true);
    }

    boolean updateDelete(TextStream poStream, int nIndex, int nChange) {
        if (this.mnIgnoreUpdates > 0) {
            return true;
        }
        this.moChange.delete(poStream, nIndex, nChange);
        return this.layout(true);
    }

    boolean updateOther(TextStream poStream, int nIndex, int nCount) {
        if (this.mnIgnoreUpdates > 0) {
            return true;
        }
        this.moChange.other(poStream, nIndex, nCount);
        return this.layout(true);
    }

    boolean updateToEnd(TextStream poStream, int nIndex) {
        if (this.mnIgnoreUpdates > 0) {
            return true;
        }
        this.moChange.toEnd(poStream, nIndex);
        return this.layout(true);
    }

    void updateJustify() {
        if (this.mnIgnoreUpdates > 0) {
            return;
        }
        this.moChange.setJustify();
        this.layout(true);
    }

    void detach(TextStream poStream) {
        if (poStream != this.mpoStream) {
            this.update();
        }
        poStream.textDisplaySet(null);
    }

    void ignoreUpdates(boolean bIgnore) {
        if (bIgnore) {
            ++this.mnIgnoreUpdates;
        } else {
            assert (this.mnIgnoreUpdates > 0);
            --this.mnIgnoreUpdates;
        }
    }

    UnitSpan caretUp(TextPosnBase oPosn, UnitSpan poTarget, TextPosnBase oResult) {
        return this.vertMove(oPosn, true, poTarget, oResult);
    }

    UnitSpan caretDown(TextPosnBase oPosn, UnitSpan poTarget, TextPosnBase oResult) {
        return this.vertMove(oPosn, false, poTarget, oResult);
    }

    boolean caretStartEnd(TextPosnBase oPosn, boolean bEnd, boolean bVisual, TextPosnBase oResult) {
        FrameCaretStartEnd oCaret = new FrameCaretStartEnd(this.mpoStream, oPosn, bEnd, bVisual, oResult);
        oCaret.processFrames();
        return oCaret.success();
    }

    int caretLeftRight(TextPosnBase oPosn, boolean bRight, TextPosnBase oResult) {
        int eOtherCaret;
        TextPosnBase oOtherPosn;
        int pcChar;
        block7: {
            DispLineWrapped poLine;
            TextFrame poFrame;
            int nLineIndex;
            int nFrameIndex;
            block8: {
                FindCaretInfo findInfo = this.findCaretLine(oPosn);
                if (findInfo == null) {
                    return 0;
                }
                nFrameIndex = findInfo.mFrameIndex;
                nLineIndex = findInfo.mLineIndex;
                poFrame = this.mpoStream.getFrame(nFrameIndex);
                poLine = poFrame.getLine(nLineIndex);
                pcChar = poLine.getCaretLeftRight(oPosn, bRight, oResult);
                if (pcChar != 0) {
                    return pcChar;
                }
                oOtherPosn = new TextPosnBase();
                eOtherCaret = 0;
                if (bRight != this.isRTL()) break block8;
                do {
                    if (nLineIndex != 0) continue;
                    if (nFrameIndex == 0) break block7;
                    poFrame = this.mpoStream.forceFrame(--nFrameIndex);
                    nLineIndex = poFrame.getLineCount();
                } while (nLineIndex <= 0 || (eOtherCaret = (poLine = poFrame.getLine(--nLineIndex)).getCaretStartEnd(oPosn.stream(), true, true, oOtherPosn)) == 0);
                if (this.isRTL()) {
                    oOtherPosn.affinity(0);
                }
                pcChar = poLine.getLastGlyphChar();
                break block7;
                {
                }
            }
            pcChar = poLine.getLastGlyphChar();
            do {
                if (++nLineIndex < poFrame.getLineCount()) continue;
                if (++nFrameIndex >= this.mpoStream.getFrameCount()) break;
                poFrame = this.mpoStream.forceFrame(nFrameIndex);
                nLineIndex = 0;
            } while ((eOtherCaret = (poLine = poFrame.getLine(nLineIndex)).getCaretStartEnd(oPosn.stream(), false, true, oOtherPosn)) == 0);
        }
        if (eOtherCaret == 0) {
            return 0;
        }
        oResult.copyFrom(oOtherPosn);
        return pcChar;
    }

    void checkAXTELigature(TextPosnBase oPosn, boolean bForward) {
        FindCaretInfo info = this.findCaretLine(oPosn);
        if (info == null) {
            return;
        }
        TextFrame poFrame = this.mpoStream.getFrame(info.mFrameIndex);
        poFrame.getLine(info.mLineIndex).checkAXTELigature(oPosn, bForward);
    }

    boolean isAtStart(TextPosnBase oPosn, boolean bCheckFirstLineOnly) {
        FindCaretInfo info = this.findCaretLine(oPosn);
        if (info == null) {
            return false;
        }
        if (bCheckFirstLineOnly && (info.mFrameIndex > 0 || info.mLineIndex > 0)) {
            return false;
        }
        TextFrame poFrame = this.mpoStream.getFrame(info.mFrameIndex);
        return poFrame.getLine(info.mLineIndex).isAtStart(oPosn);
    }

    TextContext getContext() {
        return this.mpoStream == null ? null : this.mpoStream.forceContext();
    }

    GFXEnv getGFXEnv() {
        return this.mpoEnv;
    }

    DispChange getChange() {
        return this.moChange;
    }

    DispMapSet getDisposableMaps() {
        return this.getContext().getDisposableMaps();
    }

    public void releaseDisposableMaps(DispMapSet poMaps) {
        this.getContext().releaseDisposableMaps(poMaps);
    }

    void setLocale(TextAttr poAttr) {
        int eDirection = 0;
        String sLocale = "";
        if (poAttr != null) {
            eDirection = poAttr.paraDirection();
            if (eDirection == 0) {
                eDirection = poAttr.direction();
            }
            sLocale = poAttr.actualLocale();
        }
        this.moLocaleInfo = this.getContext().lookupLocale(sLocale);
        this.moLocaleInfo = new LocaleInfo(this.moLocaleInfo);
        if (this.mpoStream.defaultDirection() != 0) {
            eDirection = this.mpoStream.defaultDirection();
        }
        switch (eDirection) {
            case 1: {
                this.moLocaleInfo.mbIsRTL = false;
                break;
            }
            case 2: {
                this.moLocaleInfo.mbIsRTL = true;
            }
        }
    }

    LocaleInfo getLocale(String sLocaleName) {
        return this.getContext().lookupLocale(sLocaleName);
    }

    TextBreakFinder getBreakFinder() {
        this.mpoBreakFinder = TextBreakFinder.recycle(this.moLocaleInfo.mpoLocale, this.mpoBreakFinder);
        return this.mpoBreakFinder;
    }

    int getLayoutOrientation() {
        return this.meLayoutOrientation;
    }

    boolean isRTL(TextAttr poAttr) {
        boolean bRTL = this.moLocaleInfo.mbIsRTL;
        if (poAttr != null) {
            int eDirection = poAttr.direction();
            if (eDirection == 1) {
                bRTL = false;
            } else if (eDirection == 2) {
                bRTL = true;
            } else {
                LocaleInfo oLocaleInfo = this.getContext().lookupLocale(poAttr.actualLocale());
                bRTL = oLocaleInfo.mbIsRTL;
            }
        }
        return bRTL;
    }

    boolean isRTL() {
        return this.isRTL(null);
    }

    boolean isIdeographic(TextAttr poAttr) {
        boolean bIdeographic = this.moLocaleInfo.mbIsIdeographic;
        if (poAttr != null) {
            LocaleInfo oLocaleInfo = this.getContext().lookupLocale(poAttr.actualLocale());
            bIdeographic = oLocaleInfo.mbIsIdeographic;
        }
        return bIdeographic;
    }

    boolean isIdeographic() {
        return this.isIdeographic(null);
    }

    int getDigits(TextAttr poAttr) {
        if (poAttr == null || poAttr.digits() == 0) {
            return this.moLocaleInfo.meDigits;
        }
        return poAttr.digits();
    }

    boolean[] getBreakCandidates(int nCount, int nPreserve) {
        return this.getContext().getBreakCandidates(nCount, nPreserve);
    }

    boolean[] getBreakCandidates(int nCount) {
        return this.getContext().getBreakCandidates(nCount, 0);
    }

    int getLegacyLevel() {
        return this.mpoStream.getLegacyLevel();
    }

    FindCaretInfo findCaretLine(TextPosnBase oPosn) {
        FrameCaretRect oSearch = new FrameCaretRect(this.mpoStream, oPosn, false, true);
        oSearch.processFrames();
        if (!oSearch.success()) {
            return null;
        }
        return new FindCaretInfo(oSearch.getFrameIndex(), oSearch.getLineIndex(), oSearch.getCaret());
    }

    private boolean layout(boolean bUpdate, int nFrameIndex, boolean bSuppressSuspectFrames, TextAttr poDefaultAttr) {
        TextFrame poFrame;
        if (this.mnSuppressFormat > 0 || this.mnIgnoreUpdates > 0) {
            return true;
        }
        if (this.mpoStream.getFrameCount() > 0 && (poFrame = this.mpoStream.getFrame(0)) != null && !poFrame.alignHPoint() && poFrame.minWidth() != poFrame.maxWidth()) {
            this.moChange.full();
        }
        TextPosnBase oStartStream = new TextPosnBase(this.mpoStream);
        TextAttr poAttr = oStartStream.attributePtr();
        int eJustH = 5;
        int eJustV = 1;
        this.meLayoutOrientation = 0;
        if (poAttr != null) {
            eJustH = poAttr.justifyH();
            eJustV = poAttr.justifyV();
            if (poAttr.layoutOrientationEnable()) {
                this.meLayoutOrientation = poAttr.layoutOrientation();
            }
            if (poAttr.fontEnable() && poAttr.substituteFont()) {
                this.setFontSubstitution(true);
            }
        }
        this.setLocale(poAttr);
        FormatInfo oInfo = new FormatInfo(this, this.moTabs, bUpdate, eJustH, eJustV, nFrameIndex, poDefaultAttr);
        if (oInfo.isUpdate() && oInfo.getChange().type() != 0) {
            this.mpoStream.updateLastLineFlag(false);
        }
        if (oInfo.getChange().type() != 0 && !oInfo.allInitialLayout()) {
            boolean bNewPara = oInfo.isNewPara();
            boolean bContinue = true;
            do {
                DispLineRaw oRawLine = new DispLineRaw(oInfo, bNewPara);
                bContinue = oRawLine.fill();
                bNewPara = oRawLine.isLastParaLine();
                oRawLine.detach();
            } while (bContinue);
        }
        if (oInfo.getChange().type() != 0) {
            this.mpoStream.updateLastLineFlag(true);
        }
        oInfo.finish();
        this.mnLineCount = 0;
        int nFrames = this.mpoStream.getFrameCount();
        for (int i = 0; i < nFrames; ++i) {
            TextFrame poFrame2 = this.mpoStream.getFrame(i);
            if (poFrame2 == null) continue;
            if (this.moChange.type() == 0) {
                // empty if block
            }
            this.mnLineCount += poFrame2.getLineCount();
        }
        if (oInfo.updateConnect()) {
            // empty if block
        }
        this.moChange.reset();
        if (!bSuppressSuspectFrames) {
            // empty if block
        }
        return oInfo.fits();
    }

    private boolean layout(boolean bUpdate) {
        return this.layout(bUpdate, 0, true, null);
    }

    UnitSpan vertMove(TextPosnBase oPosn, boolean bUp, UnitSpan poTarget, TextPosnBase oResult) {
        FindCaretInfo info = this.findCaretLine(oPosn);
        if (info == null) {
            return null;
        }
        Rect oCaret = info.mCaret;
        int nFrameIndex = info.mFrameIndex;
        int nLineIndex = info.mLineIndex;
        if (poTarget == null) {
            poTarget = oCaret.left().add(oCaret.right());
            poTarget = poTarget.divide(2);
        }
        TextFrame poFrame = this.mpoStream.getFrame(nFrameIndex);
        boolean bFound = false;
        if (bUp) {
            while (!bFound) {
                DispLineWrapped poLine;
                if (nLineIndex == 0) {
                    if (nFrameIndex == 0) break;
                    poFrame = this.mpoStream.forceFrame(--nFrameIndex);
                    nLineIndex = poFrame.getLineCount();
                }
                if (nLineIndex <= 0 || (poLine = poFrame.getLine(--nLineIndex)).getCaretPosn(oPosn.stream(), poTarget, oResult) == 0) continue;
                bFound = true;
            }
        } else {
            ++nLineIndex;
            while (!bFound) {
                DispLineWrapped poLine;
                if (nLineIndex >= poFrame.getLineCount()) {
                    if (++nFrameIndex >= this.mpoStream.getFrameCount()) break;
                    poFrame = this.mpoStream.forceFrame(nFrameIndex);
                    nLineIndex = 0;
                }
                if ((poLine = poFrame.getLine(nLineIndex)).getCaretPosn(oPosn.stream(), poTarget, oResult) != 0) {
                    bFound = true;
                }
                ++nLineIndex;
            }
        }
        return poTarget;
    }

    void detachStream(TextStream poStream) {
        if (poStream == null) {
            return;
        }
        poStream.textDisplaySet(null);
        Storage<TextField> oFields = new Storage<TextField>();
        poStream.enumField(oFields);
        for (int i = 0; i < oFields.size(); ++i) {
            this.detachStream((TextStream)oFields.get(i));
        }
    }

    void cleanup() {
        this.detachStream(this.mpoStream);
        this.mpoStream = null;
        this.mnSuppressFormat = 0;
        this.mnIgnoreUpdates = 0;
        this.mpoBreakFinder = null;
        this.moTabs.setSize(0);
        this.mnLineCount = 0;
        this.mbHasFontSubstitution = false;
    }

    private static Rect computeClipRect(TextSparseStream poStream) {
        return TextDisplay.computeClipRect(poStream, 1);
    }

    private static Rect computeClipRect(TextSparseStream poStream, int eInvalidDefault) {
        Rect oExtent;
        if (eInvalidDefault == 0 && poStream.display() != null) {
            oExtent = poStream.display().runtimeExtent();
        } else {
            TextFrame poFrame = poStream.forceFrame(0);
            oExtent = poFrame.getExtent();
            if (eInvalidDefault == 1) {
                UnitSpan oMaxHeight;
                UnitSpan oMaxWidth = poFrame.maxWidth();
                if (oMaxWidth.value() >= 0) {
                    oExtent = oExtent.leftRight(UnitSpan.ZERO, oMaxWidth);
                }
                if ((oMaxHeight = poFrame.maxHeight()).value() > 0) {
                    oExtent = oExtent.topBottom(UnitSpan.ZERO, oMaxHeight);
                }
            }
        }
        return oExtent;
    }

    static class FindCaretInfo {
        final int mFrameIndex;
        final int mLineIndex;
        final Rect mCaret;

        FindCaretInfo(int frameIndex, int lineIndex, Rect caret) {
            this.mFrameIndex = frameIndex;
            this.mLineIndex = lineIndex;
            this.mCaret = caret;
        }
    }
}

