/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text.markup;

import com.adobe.xfa.text.markup.MarkupAttr;

class RTFAttr
extends MarkupAttr {
    static final RTFAttr DEFAULT_RTF_ATTR = new RTFAttr();

    public RTFAttr() {
        this.initializeMap();
    }

    public boolean IsFontNameSpecifier(String oStrCommand) {
        return oStrCommand.contains("alt") || oStrCommand.contains("fname");
    }

    public static RTFAttr GetDefault() {
        return DEFAULT_RTF_ATTR;
    }

    @Override
    public char blockPrefix() {
        return '{';
    }

    @Override
    public char blockSuffix() {
        return '}';
    }

    @Override
    public char commandPrefix() {
        return '\\';
    }

    @Override
    public boolean isDelimiter(char c) {
        return !(c == '*' || c == '-' || c == '\'' || c == '\"' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9');
    }

    @Override
    public char disablingChar() {
        return '0';
    }

    @Override
    public char delimiter() {
        return ' ';
    }

    @Override
    public int pointSizeFactor() {
        return 2;
    }

    @Override
    public boolean isValidMarkup(String sRtf) {
        return sRtf.substring(0, 8).contains("\\\rtf");
    }

    protected void initializeMap() {
        this.setEntry(19, "par");
        this.setEntry(20, "pard");
        this.setEntry(21, "plain");
        this.setEntry(23, "pict");
        this.setEntry(7, "stylesheet");
        this.setEntry(8, "info");
        this.setEntry(9, "header");
        this.setEntry(10, "headerl");
        this.setEntry(11, "headerr");
        this.setEntry(12, "headerf");
        this.setEntry(13, "footer");
        this.setEntry(14, "footerl");
        this.setEntry(15, "footerr");
        this.setEntry(16, "footerf");
        this.setEntry(17, "ansicpg");
        this.setEntry(76, "fcharset");
        this.setEntry(24, "'", true);
        this.setEntry(27, "*");
        this.setEntry(26, "uc");
        this.setEntry(25, "u");
        this.setEntry(28, "endash");
        this.setEntry(29, "emdash");
        this.setEntry(30, "emspace");
        this.setEntry(31, "enspace");
        this.setEntry(32, "bullet");
        this.setEntry(33, "lquote");
        this.setEntry(34, "rquote");
        this.setEntry(35, "ldblquote");
        this.setEntry(36, "rdblquote");
        this.setEntry(37, "line");
        this.setEntry(57, "fi", true);
        this.setEntry(58, "li", true);
        this.setEntry(59, "ri", true);
        this.setEntry(61, "sb", true);
        this.setEntry(62, "sa", true);
        this.setEntry(63, "sl", true);
        this.setEntry(65, "f", true);
        this.setEntry(66, "fs", true);
        this.setEntry(74, "deff", true);
        this.setEntry(77, "b");
        this.setEntry(78, "b0");
        this.setEntry(79, "i");
        this.setEntry(80, "i0");
        this.setEntry(99, "uldashdd");
        this.setEntry(98, "uldashd");
        this.setEntry(97, "uldash");
        this.setEntry(86, "uldb");
        this.setEntry(96, "uld");
        this.setEntry(85, "ul");
        this.setEntry(87, "ulw");
        this.setEntry(91, "ulnone");
        this.setEntry(100, "ulhwave");
        this.setEntry(101, "ulldash");
        this.setEntry(102, "ulth");
        this.setEntry(103, "ulthd");
        this.setEntry(104, "ulthdash");
        this.setEntry(105, "ulthdashd");
        this.setEntry(106, "ulthdashdd");
        this.setEntry(107, "ulthldash");
        this.setEntry(108, "ululdbwave");
        this.setEntry(109, "ulwave");
        this.setEntry(90, "ul0");
        this.setEntry(113, "super");
        this.setEntry(115, "sub");
        this.setEntry(81, "strike");
        this.setEntry(82, "striked");
        this.setEntry(83, "strike0");
        this.setEntry(84, "colortbl");
        this.setEntry(75, "cf", true);
        this.setEntry(117, "dn", true);
        this.setEntry(118, "up", true);
        this.setEntry(120, "qj");
        this.setEntry(122, "ql");
        this.setEntry(123, "qc");
        this.setEntry(124, "qr");
        this.setEntry(136, "tab");
        this.setEntry(137, "deftab", true);
        this.setEntry(138, "tx", true);
        this.setEntry(140, "tqc");
        this.setEntry(141, "tqr");
        this.setEntry(142, "tqd");
        this.setEntry(148, "s");
        this.setEntry(149, "cs");
        this.setEntry(151, "sbasedon");
        this.setEntry(150, "additive");
        this.setEntry(152, "row");
        this.setEntry(153, "cell");
        this.setMarkupEntry(1, "caps");
        this.setMarkupEntry(1, "deleted");
        this.setMarkupEntry(1, "nosupersub");
        this.setMarkupEntry(1, "expnd");
        this.setMarkupEntry(1, "expndtw");
        this.setMarkupEntry(1, "kerning");
        this.setMarkupEntry(1, "outl");
        this.setMarkupEntry(1, "shad");
        this.setMarkupEntry(1, "v");
        this.setMarkupEntry(1, "cb");
        this.setMarkupEntry(1, "rtlch");
        this.setMarkupEntry(1, "ltrch");
        this.setMarkupEntry(1, "cchs");
        this.setMarkupEntry(1, "lang");
        this.setMarkupEntry(1, "trowd");
        this.setMarkupEntry(1, "trleft");
        this.setMarkupEntry(1, "cl");
        this.setMarkupEntry(1, "ch");
        this.setMarkupEntry(1, "trowd");
        this.setMarkupEntry(1, "cellx");
    }
}

